/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.tycho.PlatformPropertiesUtils;
import org.codehaus.tycho.TargetEnvironment;
import org.codehaus.tycho.TargetPlatform;
import org.codehaus.tycho.TargetPlatformResolver;
import org.codehaus.tycho.TychoConstants;
import org.codehaus.tycho.maven.DependenciesReader;
import org.codehaus.tycho.osgitools.targetplatform.LocalTargetPlatformResolver;
import org.codehaus.tycho.osgitools.utils.TychoVersion;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="TychoMavenLifecycleListener")
public class TychoMavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    @Requirement
    private PlexusContainer container;
    @Requirement
    private Logger logger;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        if ("maven".equals(session.getExecutionProperties().get("tycho.mode"))) {
            return;
        }
        List projects = session.getProjects();
        MavenExecutionRequest request = session.getRequest();
        for (MavenProject project : projects) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)project.getProperties());
            properties.putAll((Map<?, ?>)session.getExecutionProperties());
            project.setContextValue(TychoConstants.CTX_MERGED_PROPERTIES, (Object)properties);
            TargetEnvironment environment = this.getTargetEnvironment(project);
            project.setContextValue(TychoConstants.CTX_TARGET_ENVIRONMENT, (Object)environment);
            TargetPlatformResolver resolver = TychoMavenLifecycleParticipant.lookupPlatformResolver(this.container, properties);
            resolver.setLocalRepository(request.getLocalRepository());
            resolver.setMavenProjects(new ArrayList<MavenProject>(projects));
            try {
                DependenciesReader dr = (DependenciesReader)this.container.lookup(DependenciesReader.class, project.getPackaging());
                this.logger.info("Resolving target platform for project " + project);
                TargetPlatform targetPlatform = resolver.resolvePlatform(project, null);
                project.setContextValue(TychoConstants.CTX_TARGET_PLATFORM, (Object)targetPlatform);
                for (Dependency dependency : dr.getDependencies(session, project)) {
                    project.getModel().addDependency(dependency);
                }
            }
            catch (ComponentLookupException e) {
            }
        }
    }

    private TargetEnvironment getTargetEnvironment(MavenProject project) throws MavenExecutionException {
        TargetEnvironment environment = null;
        Plugin plugin = project.getPlugin("org.codehaus.tycho:target-platform-configuration");
        if (plugin != null) {
            Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
            environment = this.getTargetEnvironment(configuration);
        }
        if (environment == null) {
            Properties properties = (Properties)project.getContextValue(TychoConstants.CTX_MERGED_PROPERTIES);
            String os = PlatformPropertiesUtils.getOS(properties);
            String ws = PlatformPropertiesUtils.getWS(properties);
            String arch = PlatformPropertiesUtils.getArch(properties);
            environment = new TargetEnvironment(os, ws, arch, null);
        }
        return environment;
    }

    private TargetEnvironment getTargetEnvironment(Xpp3Dom configuration) {
        if (configuration == null) {
            return null;
        }
        Xpp3Dom environmentDom = configuration.getChild("environment");
        if (environmentDom == null) {
            return null;
        }
        Xpp3Dom osDom = environmentDom.getChild("os");
        if (osDom == null) {
            return null;
        }
        Xpp3Dom wsDom = environmentDom.getChild("ws");
        if (wsDom == null) {
            return null;
        }
        Xpp3Dom archDom = environmentDom.getChild("arch");
        if (archDom == null) {
            return null;
        }
        return new TargetEnvironment(osDom.getValue(), wsDom.getValue(), archDom.getValue(), null);
    }

    public static TargetPlatformResolver lookupPlatformResolver(PlexusContainer container, Properties properties) {
        TargetPlatformResolver resolver;
        String property = properties.getProperty("tycho.targetPlatform");
        if (property != null) {
            TargetPlatformResolver resolver2;
            File location = new File(property);
            if (!location.exists() || !location.isDirectory()) {
                throw new RuntimeException("Invalid target platform location: " + property);
            }
            try {
                resolver2 = (TargetPlatformResolver)container.lookup(TargetPlatformResolver.class, "local");
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException("Could not instantiate required component", e);
            }
            ((LocalTargetPlatformResolver)resolver2).setLocation(new File(property));
            return resolver2;
        }
        String resolverRole = properties.getProperty("tycho.resolver", "tycho03");
        try {
            resolver = (TargetPlatformResolver)container.lookup(TargetPlatformResolver.class, resolverRole);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Could not instantiate required component", e);
        }
        return resolver;
    }

    public void afterSessionStart(MavenSession session) {
        session.getExecutionProperties().setProperty("tycho-version", TychoVersion.getTychoVersion());
    }
}

