/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reactor.MavenExecutionException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.tycho.BundleResolutionState;
import org.codehaus.tycho.TychoSession;
import org.codehaus.tycho.maven.DependenciesReader;
import org.codehaus.tycho.osgitools.AbstractDependenciesReader;
import org.codehaus.tycho.osgitools.DependencyComputer;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=DependenciesReader.class, hint="eclipse-plugin")
public class OsgiBundleDependenciesReader
extends AbstractDependenciesReader {
    @Requirement
    private DependencyComputer dependencyComputer;

    @Override
    public List<Dependency> getDependencies(MavenProject project, TychoSession session) throws MavenExecutionException {
        BundleResolutionState state = session.getBundleResolutionState(project);
        BundleDescription bundleDescription = state.getBundleByLocation(project.getBasedir());
        if (bundleDescription == null) {
            return NO_DEPENDENCIES;
        }
        try {
            state.assertResolved(bundleDescription);
        }
        catch (BundleException e) {
            throw new MavenExecutionException(e.getMessage(), project.getFile());
        }
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (DependencyComputer.DependencyEntry entry : this.dependencyComputer.computeDependencies(state, bundleDescription)) {
            BundleDescription supplier = entry.desc;
            Dependency dependency = this.newBundleDependency(session, supplier);
            if (dependency == null) continue;
            result.add(dependency);
        }
        return result;
    }
}

