/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.tycho.osgitools.OsgiState;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=DependencyComputer.class)
public class DependencyComputer {
    static final String ROLE = DependencyComputer.class.getName();
    @Requirement
    OsgiState state;

    public List<DependencyEntry> computeDependencies(BundleDescription desc) {
        ArrayList<DependencyEntry> entries = new ArrayList<DependencyEntry>();
        if (desc == null) {
            return entries;
        }
        Map<BundleDescription, ArrayList<AccessRule>> map = this.retrieveVisiblePackagesFromState(desc);
        HashSet<BundleDescription> added = new HashSet<BundleDescription>();
        added.add(desc);
        HostSpecification host = desc.getHost();
        if (host != null) {
            this.addHostPlugin(host, added, map, entries);
        }
        BundleSpecification[] required = desc.getRequiredBundles();
        for (int i = 0; i < required.length; ++i) {
            this.addDependency((BundleDescription)required[i].getSupplier(), added, map, entries);
        }
        TreeMap<String, BundleDescription> sortedMap = new TreeMap<String, BundleDescription>();
        for (BundleDescription bundle : map.keySet()) {
            sortedMap.put(bundle.toString(), bundle);
        }
        for (BundleDescription bundle : sortedMap.values()) {
            this.addDependencyViaImportPackage(bundle, added, map, entries);
        }
        return entries;
    }

    private Map<BundleDescription, ArrayList<AccessRule>> retrieveVisiblePackagesFromState(BundleDescription desc) {
        HashMap<BundleDescription, ArrayList<AccessRule>> visiblePackages = new HashMap<BundleDescription, ArrayList<AccessRule>>();
        StateHelper helper = this.state.getStateHelper();
        this.addVisiblePackagesFromState(helper, desc, visiblePackages);
        if (desc.getHost() != null) {
            this.addVisiblePackagesFromState(helper, (BundleDescription)desc.getHost().getSupplier(), visiblePackages);
        }
        return visiblePackages;
    }

    private void addVisiblePackagesFromState(StateHelper helper, BundleDescription desc, Map<BundleDescription, ArrayList<AccessRule>> visiblePackages) {
        if (desc == null) {
            return;
        }
        ExportPackageDescription[] exports = helper.getVisiblePackages(desc);
        for (int i = 0; i < exports.length; ++i) {
            AccessRule rule;
            BundleDescription exporter = exports[i].getExporter();
            if (exporter == null) continue;
            ArrayList<AccessRule> list = visiblePackages.get(exporter);
            if (list == null) {
                list = new ArrayList();
            }
            if (!list.contains(rule = this.getRule(helper, desc, exports[i]))) {
                list.add(rule);
            }
            visiblePackages.put(exporter, list);
        }
    }

    private AccessRule getRule(StateHelper helper, BundleDescription desc, ExportPackageDescription export) {
        AccessRule rule = new AccessRule();
        rule.discouraged = helper.getAccessCode(desc, export) == 2;
        String name = export.getName();
        rule.path = name.equals(".") ? "*" : name.replaceAll("\\.", "/") + "/*";
        return rule;
    }

    protected void addDependencyViaImportPackage(BundleDescription desc, HashSet<BundleDescription> added, Map<BundleDescription, ArrayList<AccessRule>> map, ArrayList<DependencyEntry> entries) {
        if (desc == null || !added.add(desc)) {
            return;
        }
        this.addPlugin(desc, true, map, entries);
        if (this.hasExtensibleAPI(desc) && desc.getContainingState() != null) {
            BundleDescription[] fragments = desc.getFragments();
            for (int i = 0; i < fragments.length; ++i) {
                if (!fragments[i].isResolved()) continue;
                this.addDependencyViaImportPackage(fragments[i], added, map, entries);
            }
        }
    }

    private void addDependency(BundleDescription desc, HashSet<BundleDescription> added, Map<BundleDescription, ArrayList<AccessRule>> map, ArrayList<DependencyEntry> entries) {
        this.addDependency(desc, added, map, entries, true);
    }

    private void addDependency(BundleDescription desc, HashSet<BundleDescription> added, Map<BundleDescription, ArrayList<AccessRule>> map, ArrayList<DependencyEntry> entries, boolean useInclusion) {
        int i;
        if (desc == null || !added.add(desc)) {
            return;
        }
        BundleDescription[] fragments = this.hasExtensibleAPI(desc) ? desc.getFragments() : new BundleDescription[]{};
        for (i = 0; i < fragments.length; ++i) {
            if (!fragments[i].isResolved() || !this.isPatchFragment(fragments[i])) continue;
            this.addDependency(fragments[i], added, map, entries, useInclusion);
        }
        this.addPlugin(desc, useInclusion, map, entries);
        for (i = 0; i < fragments.length; ++i) {
            if (!fragments[i].isResolved() || this.isPatchFragment(fragments[i])) continue;
            this.addDependency(fragments[i], added, map, entries, useInclusion);
        }
        BundleSpecification[] required = desc.getRequiredBundles();
        for (int i2 = 0; i2 < required.length; ++i2) {
            if (!required[i2].isExported()) continue;
            this.addDependency((BundleDescription)required[i2].getSupplier(), added, map, entries, useInclusion);
        }
    }

    private boolean isPatchFragment(BundleDescription bundleDescription) {
        return false;
    }

    private boolean addPlugin(BundleDescription desc, boolean useInclusions, Map<BundleDescription, ArrayList<AccessRule>> map, ArrayList<DependencyEntry> entries) {
        AccessRule[] rules = useInclusions ? this.getInclusions(map, desc) : null;
        DependencyEntry entry = new DependencyEntry(desc, rules);
        if (!entries.contains(entry)) {
            entries.add(entry);
        }
        return true;
    }

    private AccessRule[] getInclusions(Map<BundleDescription, ArrayList<AccessRule>> map, BundleDescription desc) {
        ArrayList<AccessRule> rules = desc.getHost() != null ? map.get((BundleDescription)desc.getHost().getSupplier()) : map.get(desc);
        return rules == null || rules.size() == 0 ? new AccessRule[]{} : rules.toArray(new AccessRule[rules.size()]);
    }

    private void addHostPlugin(HostSpecification hostSpec, HashSet<BundleDescription> added, Map<BundleDescription, ArrayList<AccessRule>> map, ArrayList<DependencyEntry> entries) {
        BundleDescription host;
        BaseDescription desc = hostSpec.getSupplier();
        if (desc instanceof BundleDescription && added.add(host = (BundleDescription)desc) && this.addPlugin(host, false, map, entries)) {
            BundleSpecification[] required = host.getRequiredBundles();
            for (int i = 0; i < required.length; ++i) {
                this.addDependency((BundleDescription)required[i].getSupplier(), added, map, entries);
            }
            ImportPackageSpecification[] imports = host.getImportPackages();
            for (int i = 0; i < imports.length; ++i) {
                BaseDescription supplier = imports[i].getSupplier();
                if (!(supplier instanceof ExportPackageDescription)) continue;
                this.addDependencyViaImportPackage(((ExportPackageDescription)supplier).getExporter(), added, map, entries);
            }
        }
    }

    private boolean hasExtensibleAPI(BundleDescription desc) {
        return true;
    }

    public static class DependencyEntry {
        public final BundleDescription desc;
        public final AccessRule[] rules;

        public DependencyEntry(BundleDescription desc, AccessRule[] rules) {
            this.desc = desc;
            this.rules = rules;
        }

        public boolean equals(Object other) {
            if (!(other instanceof DependencyEntry)) {
                return false;
            }
            return this.desc.equals(((DependencyEntry)other).desc) && Arrays.equals(this.rules, ((DependencyEntry)other).rules);
        }
    }

    public static class AccessRule {
        public String path;
        public boolean discouraged;

        public boolean equals(Object other) {
            if (!(other instanceof AccessRule)) {
                return false;
            }
            return this.discouraged == ((AccessRule)other).discouraged && this.path.equals(((AccessRule)other).path);
        }
    }
}

