/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reactor.MavenExecutionException;
import org.codehaus.tycho.maven.EclipseMavenProjetBuilder;
import org.codehaus.tycho.osgitools.AbstractDependenciesReader;
import org.codehaus.tycho.osgitools.DependencyComputer;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiBundleDependenciesReader
extends AbstractDependenciesReader {
    private DependencyComputer dependencyComputer;

    @Override
    public List<Dependency> getDependencies(MavenProject project) throws MavenExecutionException {
        BundleDescription bundleDescription = this.state.getBundleDescription(project);
        if (bundleDescription == null) {
            return NO_DEPENDENCIES;
        }
        try {
            this.state.assertResolved(bundleDescription);
        }
        catch (BundleException e) {
            throw new MavenExecutionException(e.getMessage(), project.getFile());
        }
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (DependencyComputer.DependencyEntry entry : this.dependencyComputer.computeDependencies(bundleDescription)) {
            Dependency dependency;
            BundleDescription supplier = entry.desc;
            MavenProject otherProject = this.state.getMavenProject(supplier);
            if (otherProject != null) {
                dependency = this.newProjectDependency(otherProject);
            } else {
                String groupId = EclipseMavenProjetBuilder.getGroupId(this.state, supplier);
                String artifactId = supplier.getSymbolicName();
                String version = supplier.getVersion().toString();
                dependency = this.newExternalDependency(supplier.getLocation(), groupId, artifactId, version);
            }
            if (dependency == null) continue;
            result.add(dependency);
        }
        return result;
    }
}

