/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.model.Launcher;
import org.codehaus.tycho.model.PluginRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductConfiguration {
    private Xpp3Dom dom;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProductConfiguration read(File file) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((File)file);
        try {
            ProductConfiguration productConfiguration = new ProductConfiguration(Xpp3DomBuilder.build((Reader)reader));
            return productConfiguration;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProductConfiguration read(InputStream inputStream) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)inputStream);
        try {
            ProductConfiguration productConfiguration = new ProductConfiguration(Xpp3DomBuilder.build((Reader)reader));
            return productConfiguration;
        }
        finally {
            reader.close();
            inputStream.close();
        }
    }

    public ProductConfiguration(Xpp3Dom dom) {
        this.dom = dom;
    }

    public String getApplication() {
        return this.dom.getAttribute("application");
    }

    public List<Feature.FeatureRef> getFeatures() {
        Xpp3Dom featuresDom = this.dom.getChild("features");
        if (featuresDom == null) {
            return Collections.emptyList();
        }
        ArrayList<Feature.FeatureRef> features = new ArrayList<Feature.FeatureRef>();
        for (Xpp3Dom pluginDom : featuresDom.getChildren("feature")) {
            features.add(new Feature.FeatureRef(pluginDom));
        }
        return Collections.unmodifiableList(features);
    }

    public String getId() {
        return this.dom.getAttribute("id");
    }

    public Launcher getLauncher() {
        Xpp3Dom domLauncher = this.dom.getChild("launcher");
        if (domLauncher == null) {
            return null;
        }
        return new Launcher(domLauncher);
    }

    public String getName() {
        return this.dom.getAttribute("name");
    }

    public List<PluginRef> getPlugins() {
        Xpp3Dom pluginsDom = this.dom.getChild("plugins");
        if (pluginsDom == null) {
            return Collections.emptyList();
        }
        ArrayList<PluginRef> plugins = new ArrayList<PluginRef>();
        for (Xpp3Dom pluginDom : pluginsDom.getChildren("plugin")) {
            plugins.add(new PluginRef(pluginDom));
        }
        return Collections.unmodifiableList(plugins);
    }

    public Boolean getUseFeatures() {
        return Boolean.parseBoolean(this.dom.getAttribute("useFeatures"));
    }

    public String getVersion() {
        return this.dom.getAttribute("version");
    }
}

