/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools.targetplatform;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.model.PluginRef;
import org.codehaus.tycho.osgitools.OsgiState;
import org.codehaus.tycho.osgitools.targetplatform.EclipseInstallationLayout;
import org.codehaus.tycho.osgitools.targetplatform.TargetPlatformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseTargetPlatformFactory
extends AbstractLogEnabled {
    public static final String PACKAGING_ECLIPSE_INSTALLATION = "eclipse-installation";
    public static final String PACKAGING_ECLIPSE_PLUGIN = "eclipse-plugin";
    public static final String PACKAGING_ECLIPSE_FEATURE = "eclipse-feature";
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private final PlexusContainer plexus;
    private ArtifactRepository localRepository;

    public EclipseTargetPlatformFactory(Logger logger, PlexusContainer plexus, ArtifactResolver artifactResolver, ArtifactFactory artifactFactory, ArtifactRepository localRepository) {
        this.plexus = plexus;
        this.artifactResolver = artifactResolver;
        this.artifactFactory = artifactFactory;
        this.localRepository = localRepository;
        this.enableLogging(logger);
    }

    public void createTargetPlatform(List<MavenProject> projects, OsgiState state) {
        File installation = this.getEclipseInstallation(projects);
        if (installation != null) {
            this.createTargetPlatform(state, installation);
        }
        LinkedHashSet<File> features = new LinkedHashSet<File>();
        LinkedHashSet<File> bundles = new LinkedHashSet<File>();
        HashMap<Artifact, Exception> exceptions = new HashMap<Artifact, Exception>();
        for (MavenProject project : projects) {
            Map versionMap = project.getManagedVersionMap();
            if (versionMap == null) continue;
            for (Artifact artifact : versionMap.values()) {
                try {
                    if (PACKAGING_ECLIPSE_FEATURE.equals(artifact.getType())) {
                        this.resolveFeature(artifact, features, bundles, project.getRemoteArtifactRepositories(), state);
                        continue;
                    }
                    if (!PACKAGING_ECLIPSE_PLUGIN.equals(artifact.getType())) continue;
                    this.resolvePlugin(artifact, bundles, project.getRemoteArtifactRepositories());
                }
                catch (Exception e) {
                    exceptions.put(artifact, e);
                }
            }
        }
        if (!exceptions.isEmpty()) {
            throw new TargetPlatformException("Cannot resolve target platform", exceptions);
        }
        state.addSite(new File(this.localRepository.getBasedir()), features, bundles);
    }

    public void createTargetPlatform(OsgiState state, File installation) {
        state.setTargetPlatform(installation);
        EclipseInstallationLayout finder = new EclipseInstallationLayout(this.getLogger(), installation);
        Set<File> sites = finder.getSites();
        for (File site : sites) {
            Set<File> features = finder.getFeatures(site);
            Set<File> bundles = finder.getPlugins(site);
            state.addSite(site, features, bundles);
        }
    }

    private void resolveFeature(Artifact artifact, Set<File> features, Set<File> bundles, List<ArtifactRepository> remoteRepositories, OsgiState state) throws AbstractArtifactResolutionException, IOException, XmlPullParserException {
        Artifact includedArtifact;
        this.resolveArtifact(artifact, remoteRepositories);
        Feature feature = Feature.readJar(artifact.getFile());
        features.add(artifact.getFile());
        for (PluginRef pluginRef : feature.getPlugins()) {
            includedArtifact = this.artifactFactory.createArtifact(pluginRef.getId(), pluginRef.getId(), pluginRef.getVersion(), null, PACKAGING_ECLIPSE_PLUGIN);
            this.resolvePlugin(includedArtifact, bundles, remoteRepositories);
        }
        for (Feature.FeatureRef featureRef : feature.getIncludedFeatures()) {
            includedArtifact = this.artifactFactory.createArtifact(featureRef.getId(), featureRef.getId(), featureRef.getVersion(), null, PACKAGING_ECLIPSE_FEATURE);
            this.resolveFeature(includedArtifact, features, bundles, remoteRepositories, state);
        }
    }

    private void assertResolved(Artifact artifact) throws ArtifactNotFoundException {
        if (!artifact.isResolved() || artifact.getFile() == null || !artifact.getFile().canRead()) {
            throw new ArtifactNotFoundException("Artifact is not resolved", artifact);
        }
    }

    private void resolvePlugin(Artifact artifact, Set<File> bundles, List<ArtifactRepository> remoteRepositories) throws AbstractArtifactResolutionException {
        this.resolveArtifact(artifact, remoteRepositories);
        bundles.add(artifact.getFile());
    }

    private void resolveArtifact(Artifact artifact, List<ArtifactRepository> remoteRepositories) throws AbstractArtifactResolutionException {
        this.artifactResolver.resolve(artifact, remoteRepositories, this.localRepository);
        this.assertResolved(artifact);
    }

    private File getEclipseInstallation(List<MavenProject> projects) {
        File installation = null;
        for (MavenProject project : projects) {
            Map versionMap = project.getManagedVersionMap();
            if (versionMap == null) continue;
            for (Artifact artifact : versionMap.values()) {
                if (!PACKAGING_ECLIPSE_INSTALLATION.equals(artifact.getType())) continue;
                if (installation == null) {
                    installation = artifact.getFile();
                    continue;
                }
                if (installation.equals(artifact.getFile())) continue;
                throw new TargetPlatformException("No more than one eclipse-installation and/or eclipse-distriction");
            }
        }
        return installation;
    }
}

