/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reactor.MavenExecutionException;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.model.UpdateSite;
import org.codehaus.tycho.osgitools.AbstractDependenciesReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSiteDependenciesReader
extends AbstractDependenciesReader {
    @Override
    public List<Dependency> getDependencies(MavenProject project) throws MavenExecutionException {
        try {
            File siteXml = new File(project.getBasedir(), "site.xml");
            UpdateSite site = UpdateSite.read(siteXml);
            LinkedHashSet<Dependency> result = new LinkedHashSet<Dependency>();
            for (UpdateSite.FeatureRef featureRef : site.getFeatures()) {
                if (null == featureRef) {
                    this.getLogger().warn("unexpected null featureRef in project at " + siteXml.getPath());
                    continue;
                }
                String id = featureRef.getId();
                String version = featureRef.getVersion();
                if (null == id || null == version) {
                    this.getLogger().warn("Bad site feature id=" + id + " version=" + version + " for " + siteXml.getPath());
                    continue;
                }
                Feature feature = this.state.getFeature(id, version);
                if (null == feature) {
                    this.getLogger().warn("No OSGI feature for id=" + id + " version=" + version + " for " + siteXml.getPath());
                    continue;
                }
                MavenProject mavenProject = this.state.getMavenProject(feature);
                if (null == mavenProject) {
                    this.getLogger().warn("No maven feature project for id=" + id + " version=" + version + " for " + siteXml.getPath());
                    continue;
                }
                Dependency dependency = this.newProjectDependency(mavenProject);
                if (dependency == null) continue;
                result.add(dependency);
            }
            return new ArrayList<Dependency>(result);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (null == m) {
                m = e.getClass().getName();
            }
            MavenExecutionException me = new MavenExecutionException(m, project.getFile());
            me.initCause((Throwable)e);
            throw me;
        }
    }
}

