/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.tycho.model.IFeatureRef;
import org.codehaus.tycho.model.PluginRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Feature {
    public static final String FEATURE_XML = "feature.xml";
    private final Xpp3Dom dom;
    private final Map<String, Object> userProperties = new HashMap<String, Object>();

    public Feature(Xpp3Dom dom) {
        this.dom = dom;
    }

    public Feature(Feature other) {
        this.dom = new Xpp3Dom(other.dom);
    }

    public List<PluginRef> getPlugins() {
        ArrayList<PluginRef> plugins = new ArrayList<PluginRef>();
        for (Xpp3Dom pluginDom : this.dom.getChildren("plugin")) {
            plugins.add(new PluginRef(pluginDom));
        }
        return Collections.unmodifiableList(plugins);
    }

    public void setVersion(String version) {
        this.dom.setAttribute("version", version);
    }

    public List<FeatureRef> getIncludedFeatures() {
        ArrayList<FeatureRef> features = new ArrayList<FeatureRef>();
        for (Xpp3Dom featureDom : this.dom.getChildren("includes")) {
            features.add(new FeatureRef(featureDom));
        }
        return Collections.unmodifiableList(features);
    }

    public List<RequiresRef> getRequires() {
        ArrayList<RequiresRef> requires = new ArrayList<RequiresRef>();
        for (Xpp3Dom requiresDom : this.dom.getChildren("requires")) {
            requires.add(new RequiresRef(requiresDom));
        }
        return Collections.unmodifiableList(requires);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Feature read(File file) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((File)file);
        try {
            Feature feature = new Feature(Xpp3DomBuilder.build((Reader)reader));
            return feature;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Feature read(InputStream input) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)input);
        try {
            Feature feature = new Feature(Xpp3DomBuilder.build((Reader)reader));
            return feature;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Feature feature, File file) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)feature.dom);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public String getVersion() {
        return this.dom.getAttribute("version");
    }

    public String getId() {
        return this.dom.getAttribute("id");
    }

    public void setUserProperty(String key, Object value) {
        this.userProperties.put(key, value);
    }

    public Object getUserProperty(String key) {
        return this.userProperties.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Feature readJar(File file) throws IOException, XmlPullParserException {
        JarFile jar = new JarFile(file);
        try {
            ZipEntry ze = jar.getEntry(FEATURE_XML);
            InputStream is = jar.getInputStream(ze);
            Feature feature = Feature.read(is);
            return feature;
        }
        finally {
            jar.close();
        }
    }

    public static class ImportRef {
        private final Xpp3Dom dom;

        public ImportRef(Xpp3Dom dom) {
            this.dom = dom;
        }

        public String getPlugin() {
            return this.dom.getAttribute("plugin");
        }

        public String getFeature() {
            return this.dom.getAttribute("feature");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RequiresRef {
        private final Xpp3Dom dom;

        public RequiresRef(Xpp3Dom dom) {
            this.dom = dom;
        }

        public List<ImportRef> getImports() {
            ArrayList<ImportRef> imports = new ArrayList<ImportRef>();
            for (Xpp3Dom importsDom : this.dom.getChildren("import")) {
                imports.add(new ImportRef(importsDom));
            }
            return Collections.unmodifiableList(imports);
        }
    }

    public static class FeatureRef
    implements IFeatureRef {
        private final Xpp3Dom dom;

        public FeatureRef(Xpp3Dom dom) {
            this.dom = dom;
        }

        public String getId() {
            return this.dom.getAttribute("id");
        }

        public String getVersion() {
            return this.dom.getAttribute("version");
        }

        public void setVersion(String version) {
            this.dom.setAttribute("version", version);
        }
    }
}

