/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.DefaultMaven;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reactor.MavenExecutionException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.tycho.maven.DependenciesReader;
import org.codehaus.tycho.osgitools.OsgiState;
import org.codehaus.tycho.osgitools.utils.TychoVersion;
import org.codehaus.tycho.p2.P2;
import org.codehaus.tycho.p2.P2ArtifactRepositoryLayout;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseMaven
extends DefaultMaven {
    private OsgiState state;
    private P2 p2;

    protected List getProjects(MavenExecutionRequest request) throws MavenExecutionException {
        request.setProperty("tycho-version", TychoVersion.getTychoVersion());
        List projects = super.getProjects(request);
        this.resolveOSGiState(projects, request);
        return projects;
    }

    private void resolveOSGiState(List<MavenProject> projects, MavenExecutionRequest request) throws MavenExecutionException {
        Properties props = this.getGlobalProperties(request);
        File workspace = null;
        File targetPlatform = null;
        if (projects.size() > 0) {
            MavenProject parent = projects.get(0);
            workspace = new File(parent.getBuild().getDirectory());
            List<String> repositories = this.getP2Repositories(projects, request);
            List<Artifact> rootIUs = this.getP2Dependencies(projects, request);
            if (!rootIUs.isEmpty()) {
                String key = this.getProfileName(parent);
                String location = this.p2.materializeTargetPlatform(key, repositories, rootIUs, props);
                targetPlatform = new File(location);
            }
        }
        this.state.init(targetPlatform, workspace, props);
        for (MavenProject project : projects) {
            try {
                this.state.addProject(project);
            }
            catch (BundleException e) {
                throw new MavenExecutionException(e.getMessage(), project.getFile());
            }
        }
        this.state.resolveState();
        try {
            for (MavenProject project : projects) {
                DependenciesReader dr = (DependenciesReader)this.container.lookup(DependenciesReader.class, project.getPackaging());
                if (dr == null) continue;
                for (Dependency dependency : dr.getDependencies(project)) {
                    project.getModel().addDependency(dependency);
                }
            }
        }
        catch (ComponentLookupException e) {
            // empty catch block
        }
    }

    private String getProfileName(MavenProject parent) throws MavenExecutionException {
        try {
            return parent.getBasedir().getCanonicalPath();
        }
        catch (IOException e) {
            throw new MavenExecutionException("Can't create p2 profile name", e);
        }
    }

    private Properties getGlobalProperties(MavenExecutionRequest request) {
        List activeProfiles = request.getActiveProfiles();
        Map profiles = request.getProfileManager().getProfilesById();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        for (Profile profile : profiles.values()) {
            Activation activation = profile.getActivation();
            if ((activation == null || !activation.isActiveByDefault()) && !activeProfiles.contains(profile.getId())) continue;
            props.putAll((Map<?, ?>)profile.getProperties());
        }
        props.putAll((Map<?, ?>)request.getProperties());
        props.putAll((Map<?, ?>)request.getUserProperties());
        return props;
    }

    private List<String> getP2Repositories(List<MavenProject> projects, MavenExecutionRequest request) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        List remoteRepositories = request.getRemoteRepositories();
        this.addP2Repositories(result, remoteRepositories);
        for (MavenProject project : projects) {
            this.addP2Repositories(result, project.getRemoteArtifactRepositories());
        }
        return new ArrayList<String>(result);
    }

    private void addP2Repositories(Set<String> result, List<ArtifactRepository> remoteRepositories) {
        if (remoteRepositories != null) {
            for (ArtifactRepository repository : remoteRepositories) {
                if (!(repository.getLayout() instanceof P2ArtifactRepositoryLayout)) continue;
                result.add(repository.getUrl());
            }
        }
    }

    private List<Artifact> getP2Dependencies(List<MavenProject> projects, MavenExecutionRequest request) {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (MavenProject project : projects) {
            Map versionMap = project.getManagedVersionMap();
            if (versionMap == null) continue;
            for (Artifact artifact : versionMap.values()) {
                if (!"osgi-bundle".equals(artifact.getType())) continue;
                result.add(artifact);
            }
        }
        return new ArrayList<Artifact>(result);
    }
}

