/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.plugin.template;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;

public class TemplateMojo
extends AbstractMojo {
    public String template;
    public File target;
    private File installDirectory;
    public MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] jarFiles = new File(this.installDirectory, "plugins").list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        for (int i = 0; i < jarFiles.length; ++i) {
            jarFiles[i] = "plugins/" + jarFiles[i];
        }
        this.createFeatureJNLP(jarFiles);
    }

    private void createFeatureJNLP(String[] pluginLocations) throws MojoExecutionException {
        for (int i = 0; i < pluginLocations.length; ++i) {
            pluginLocations[i] = pluginLocations[i].replace('\\', '/');
        }
        try {
            VelocityEngine ve = new VelocityEngine();
            ve.setProperty("resource.loader.class", (Object)FileResourceLoader.class.getName());
            ve.setProperty("file.resource.loader.path", (Object)this.project.getBasedir().getPath());
            ve.init();
            VelocityContext context = new VelocityContext();
            context.put("plugins", (Object)pluginLocations);
            FileWriter w = new FileWriter(this.target);
            ve.getTemplate(this.template).merge((Context)context, (Writer)w);
            ((Writer)w).close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating feature jnlp with velocity", e);
        }
    }
}

