/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.plugin.osgi;

import java.io.File;
import java.io.FileFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.tycho.osgitools.OsgiState;

public class ApplicationDependencyVerifierMojo
extends AbstractMojo {
    private File install;
    private boolean failOnError;
    private OsgiState state;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] jars = this.install.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar") || pathname.isDirectory();
            }
        });
        for (int i = 0; i < jars.length; ++i) {
            File jar = jars[i];
            try {
                this.state.addBundle(jar);
                continue;
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Error adding bundle " + jar));
            }
        }
        this.state.resolveState();
        Object errors = null;
        for (int i = 0; i < (errors).length; ++i) {
            void error = errors[i];
            this.getLog().error((CharSequence)("Bundle " + error.getBundle().getSymbolicName() + " - " + error.toString()));
        }
        if ((errors).length > 0 && this.failOnError) {
            throw new MojoFailureException("Errors found while verifying installation");
        }
    }
}

