/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.model.UpdateSite;
import org.codehaus.tycho.osgitools.OsgiState;
import org.eclipse.osgi.framework.adaptor.FilePath;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratePomsMojo
extends AbstractMojo {
    private static final String THIS_MODULE = ".";
    private OsgiState state;
    private File baseDir;
    private String extraDirs;
    private String groupId;
    private String version;
    private boolean aggregator;
    private String testSuffix;
    private String testSuite;
    private File templatesDir;
    MavenXpp3Reader modelReader = new MavenXpp3Reader();
    MavenXpp3Writer modelWriter = new MavenXpp3Writer();
    private Map<File, Model> updateSites = new LinkedHashMap<File, Model>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] baseDirs = this.getBaseDirs();
        if (this.getLog().isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("baseDir=").append(this.toString(this.baseDir)).append('\n');
            sb.append("extraDirs=").append(this.extraDirs).append('\n');
            for (int i = 0; i < baseDirs.length; ++i) {
                sb.append("dir[").append(i).append("]=").append(this.toString(baseDirs[i])).append('\n');
            }
            this.getLog().debug((CharSequence)sb.toString());
        }
        for (File basedir : baseDirs) {
            BundleDescription bundle;
            TreeSet<File> dirs;
            this.getLog().info((CharSequence)("Scanning " + this.toString(basedir) + " basedir"));
            if (this.generatePom(null, basedir)) continue;
            if (this.groupId == null) {
                throw new MojoExecutionException("groupId is required");
            }
            Model parent = this.readPomTemplate("parent-pom.xml");
            parent.setGroupId(this.groupId);
            parent.setArtifactId(basedir.getName());
            parent.setVersion(this.version);
            File[] listFiles = basedir.listFiles();
            if (null == listFiles) {
                listFiles = new File[]{};
            }
            if ((dirs = new TreeSet<File>(Arrays.asList(listFiles))) != null) {
                for (File dir : dirs) {
                    if (!this.generatePom(parent, dir)) continue;
                    parent.addModule(this.getModuleName(basedir, dir));
                }
            }
            File testSuiteLocation = null;
            if (this.testSuite != null && (bundle = this.state.getBundleDescription(this.testSuite, "highest version")) != null) {
                testSuiteLocation = new File(bundle.getLocation());
            }
            this.reorderModules(parent, basedir, testSuiteLocation);
            this.writePom(basedir, parent);
        }
        File testSuiteLocation = null;
        if (this.testSuite != null) {
            BundleDescription bundle = this.state.getBundleDescription(this.testSuite, "highest version");
            if (bundle == null) {
                throw new MojoExecutionException("Cannot find project defining testSuite " + this.testSuite);
            }
            testSuiteLocation = new File(bundle.getLocation());
        }
        this.generateAggregatorPoms(testSuiteLocation);
    }

    private void reorderModules(Model parent, File basedir, File testSuiteLocation) throws MojoExecutionException {
        List modules = parent.getModules();
        Collections.sort(modules);
        if (testSuiteLocation != null) {
            String moduleName = this.getModuleName(basedir, testSuiteLocation);
            modules.remove(moduleName);
            modules.add(moduleName);
        }
        if (modules.contains(THIS_MODULE)) {
            modules.remove(THIS_MODULE);
            modules.add(THIS_MODULE);
        }
    }

    private String toString(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    private File[] getBaseDirs() {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(this.baseDir);
        if (this.extraDirs != null) {
            StringTokenizer st = new StringTokenizer(this.extraDirs, ",");
            while (st.hasMoreTokens()) {
                try {
                    dirs.add(new File(st.nextToken()).getCanonicalFile());
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)"Can't parse extraDirs", (Throwable)e);
                }
            }
        }
        return dirs.toArray(new File[dirs.size()]);
    }

    private String getModuleName(File basedir, File dir) throws MojoExecutionException {
        File relative = new File(new FilePath(basedir).makeRelative(new FilePath(dir)));
        return relative.getPath().replace('\\', '/');
    }

    private void generateAggregatorPoms(File testSuiteLocation) throws MojoExecutionException {
        this.state.resolveState();
        for (Map.Entry<File, Model> updateSite : this.updateSites.entrySet()) {
            File basedir = updateSite.getKey();
            Model parent = updateSite.getValue();
            Set<File> modules = this.getSiteFeaturesAndPlugins(basedir);
            if (!this.aggregator || modules.size() <= 0) continue;
            Model modela = this.readPomTemplate("update-site-poma.xml");
            this.setParent(modela, parent);
            modela.setGroupId(this.groupId);
            modela.setArtifactId(basedir.getName() + ".aggregator");
            modela.setVersion(this.version);
            for (File module : modules) {
                modela.addModule(this.getModuleName(basedir, module));
            }
            this.reorderModules(modela, basedir, testSuiteLocation);
            this.writePom(basedir, "poma.xml", modela);
        }
    }

    private boolean generatePom(Model parent, File basedir) throws MojoExecutionException {
        if (this.isPluginProject(basedir)) {
            this.getLog().debug((CharSequence)("Found plugin PDE project " + this.toString(basedir)));
            this.generatePluginPom(parent, basedir);
        } else if (this.isFeatureProject(basedir)) {
            this.getLog().debug((CharSequence)("Found feature PDE project " + this.toString(basedir)));
            this.generateFeaturePom(parent, basedir);
        } else if (this.isUpdateSiteProject(basedir)) {
            this.getLog().debug((CharSequence)("Found update site PDE project " + this.toString(basedir)));
            this.generateUpdateSitePom(parent, basedir);
        } else {
            this.getLog().debug((CharSequence)("Not a PDE project " + this.toString(basedir)));
            return false;
        }
        return true;
    }

    private boolean isUpdateSiteProject(File dir) {
        return new File(dir, "site.xml").canRead();
    }

    private boolean isFeatureProject(File dir) {
        return new File(dir, "feature.xml").canRead();
    }

    private boolean isPluginProject(File dir) {
        return new File(dir, "META-INF/MANIFEST.MF").canRead();
    }

    private void generateUpdateSitePom(Model parent, File basedir) throws MojoExecutionException {
        if (this.groupId == null) {
            throw new MojoExecutionException("groupId parameter is required to generate pom.xml for Update Site project " + basedir.getName());
        }
        if (this.version == null) {
            throw new MojoExecutionException("version parameter is required to generate pom.xml for Update Site project " + basedir.getName());
        }
        Model model = this.readPomTemplate("update-site-pom.xml");
        this.setParent(model, parent);
        model.setGroupId(this.groupId);
        model.setArtifactId(basedir.getName());
        model.setVersion(this.version);
        this.writePom(basedir, model);
        this.updateSites.put(basedir, parent);
    }

    private Set<File> getSiteFeaturesAndPlugins(File basedir) throws MojoExecutionException {
        try {
            LinkedHashSet<File> result = new LinkedHashSet<File>();
            UpdateSite site = UpdateSite.read((File)new File(basedir, "site.xml"));
            for (UpdateSite.FeatureRef feature : site.getFeatures()) {
                this.addFeature(result, feature.getId());
            }
            return result;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not collect update site features and plugins", e);
        }
    }

    private void addFeature(Set<File> result, String name) throws IOException, XmlPullParserException, MojoExecutionException {
        File dir;
        if (name != null && (dir = this.getModuleDir(name)) != null) {
            result.add(dir);
            result.addAll(this.getFeatureFeaturesAndPlugins(dir));
        }
    }

    private File getModuleDir(String name) throws MojoExecutionException {
        File moduleDir = null;
        for (File basedir : this.getBaseDirs()) {
            File dir = new File(basedir, name);
            if (!dir.exists() || !dir.isDirectory()) continue;
            if (moduleDir != null) {
                throw new MojoExecutionException("Duplicate module directory name " + name);
            }
            moduleDir = dir;
        }
        return moduleDir;
    }

    private Set<File> getFeatureFeaturesAndPlugins(File basedir) throws IOException, XmlPullParserException, MojoExecutionException {
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        Feature feature = Feature.read((File)new File(basedir, "feature.xml"));
        for (Feature.PluginRef plugin : feature.getPlugins()) {
            this.addPlugin(result, plugin.getId());
        }
        for (Feature.FeatureRef includedFeature : feature.getIncludedFeatures()) {
            this.addFeature(result, includedFeature.getId());
        }
        for (Feature.RequiresRef require : feature.getRequires()) {
            for (Feature.ImportRef imp : require.getImports()) {
                this.addPlugin(result, imp.getPlugin());
                this.addFeature(result, imp.getFeature());
            }
        }
        return result;
    }

    private void addPlugin(Set<File> result, String name) throws MojoExecutionException {
        if (name != null) {
            this.addPluginImpl(result, name);
            this.addPluginImpl(result, name + this.testSuffix);
        }
    }

    private void addPluginImpl(Set<File> result, String name) throws MojoExecutionException {
        if (name != null) {
            File dir = this.getModuleDir(name);
            if (dir != null) {
                if (result.add(dir)) {
                    BundleDescription bundle = this.state.getBundleDescription(dir);
                    if (bundle != null) {
                        try {
                            this.state.assertResolved(bundle);
                            BundleDescription[] requiredBundles = this.state.getDependencies(bundle);
                            for (int i = 0; i < requiredBundles.length; ++i) {
                                BundleDescription supplier = requiredBundles[i].getSupplier().getSupplier();
                                File suppliedDir = new File(supplier.getLocation());
                                if (!this.isModuleDir(suppliedDir)) continue;
                                this.addPlugin(result, suppliedDir.getName());
                            }
                        }
                        catch (BundleException e) {
                            this.getLog().warn((CharSequence)"Could not determine bundle dependencies", (Throwable)e);
                        }
                    } else {
                        this.getLog().warn((CharSequence)("Not an OSGi bundle " + dir.toString()));
                    }
                }
            } else {
                this.getLog().warn((CharSequence)("Unknown bundle reference " + name));
            }
        }
    }

    private boolean isModuleDir(File dir) {
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        for (File basedir : this.getBaseDirs()) {
            if (!this.isModule(basedir, dir)) continue;
            return true;
        }
        return false;
    }

    private boolean isModule(File basedir, File dir) {
        try {
            if (basedir.getCanonicalFile().equals(dir.getParentFile().getCanonicalFile())) {
                return true;
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Totally unexpected IOException", (Throwable)e);
        }
        return false;
    }

    private void setParent(Model model, Model parentModel) {
        if (parentModel != null) {
            Parent parent = new Parent();
            parent.setGroupId(parentModel.getGroupId());
            parent.setArtifactId(parentModel.getArtifactId());
            parent.setVersion(parentModel.getVersion());
            model.setParent(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFeaturePom(Model parent, File basedir) throws MojoExecutionException {
        Model model = this.readPomTemplate("feature-pom.xml");
        this.setParent(model, parent);
        try {
            FileInputStream is = new FileInputStream(new File(basedir, "feature.xml"));
            try {
                XmlStreamReader reader = new XmlStreamReader((InputStream)is);
                Xpp3Dom dom = Xpp3DomBuilder.build((Reader)reader);
                String groupId = this.groupId;
                if (groupId == null) {
                    groupId = dom.getAttribute("id");
                }
                model.setGroupId(groupId);
                model.setArtifactId(dom.getAttribute("id"));
                model.setVersion(dom.getAttribute("version"));
            }
            finally {
                is.close();
            }
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Can't create pom.xml file", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't create pom.xml file", (Exception)e);
        }
        this.writePom(basedir, model);
    }

    private void generatePluginPom(Model parent, File dir) throws MojoExecutionException {
        try {
            BundleDescription bundleDescription = this.state.addBundle(dir);
            String groupId = this.state.getGroupId(bundleDescription);
            Model model = this.testSuffix != null && dir.getName().endsWith(this.testSuffix) || this.testSuite != null && bundleDescription.getSymbolicName().equals(this.testSuite) ? this.readPomTemplate("test-plugin-pom.xml") : this.readPomTemplate("plugin-pom.xml");
            this.setParent(model, parent);
            if (groupId == null) {
                groupId = this.groupId;
            }
            if (groupId == null) {
                groupId = bundleDescription.getSymbolicName();
            }
            model.setGroupId(groupId);
            model.setArtifactId(bundleDescription.getSymbolicName());
            model.setVersion(bundleDescription.getVersion().toString());
            this.writePom(dir, model);
        }
        catch (BundleException e) {
            throw new MojoExecutionException("Can't generate pom.xml", (Exception)((Object)e));
        }
    }

    private void writePom(File dir, Model model) throws MojoExecutionException {
        this.writePom(dir, "pom.xml", model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePom(File dir, String filename, Model model) throws MojoExecutionException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(dir, filename)), "UTF-8");
            try {
                this.modelWriter.write((Writer)writer, model);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write pom.xml", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Model readPomTemplate(String name) throws MojoExecutionException {
        Model model;
        XmlStreamReader reader;
        File file = new File(this.templatesDir, name);
        if (file.canRead()) {
            reader = ReaderFactory.newXmlReader((File)file);
        } else {
            ClassLoader cl = GeneratePomsMojo.class.getClassLoader();
            InputStream is = cl.getResourceAsStream("templates/" + name);
            XmlStreamReader xmlStreamReader = reader = is != null ? ReaderFactory.newXmlReader((InputStream)is) : null;
        }
        if (reader == null) throw new MojoExecutionException("pom.xml template cannot be found " + name);
        try {
            model = this.modelReader.read((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (XmlPullParserException e) {
                throw new MojoExecutionException("Can't read pom.xml template " + name, (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Can't read pom.xml template " + name, (Exception)e);
            }
        }
        reader.close();
        return model;
    }
}

