/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.targetplatform;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SourceManager {
    private File base;
    private File[] sourceDirs;

    public SourceManager(File base) {
        this.base = base;
        this.sourceDirs = this.findSourcePlugins();
    }

    private File[] findSourcePlugins() {
        File[] plugins = new File(this.base, "plugins").listFiles();
        ArrayList sourceDirs = new ArrayList();
        for (int i = 0; i < plugins.length; ++i) {
            File plugin = plugins[i];
            sourceDirs.addAll(SourceManager.getSourceDirs(plugin));
        }
        return sourceDirs.toArray(new File[sourceDirs.size()]);
    }

    public static List getSourceDirs(File plugin) {
        ArrayList<File> sourceDirs = new ArrayList<File>();
        File pluginXML = new File(plugin, "plugin.xml");
        if (!pluginXML.exists() && !(pluginXML = new File(plugin, "fragment.xml")).exists()) {
            return sourceDirs;
        }
        try {
            String srcValue;
            File f;
            FileReader r = new FileReader(pluginXML);
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression pdeSourcePath = xpath.compile("//extension[@point='org.eclipse.pde.core.source']/location/@path");
            Node node = (Node)pdeSourcePath.evaluate(new InputSource(r), XPathConstants.NODE);
            if (node != null && (f = new File(plugin, srcValue = node.getTextContent())).exists()) {
                sourceDirs.add(f);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return sourceDirs;
    }

    public File getSourceZip(String symbolicName, String version) {
        for (int i = 0; i < this.sourceDirs.length; ++i) {
            File dir = new File(this.sourceDirs[i], symbolicName + "_" + version);
            File result = new File(dir, "src.zip");
            if (!result.exists()) continue;
            return result;
        }
        return null;
    }
}

