/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.tycho.BundleResolutionState;
import org.codehaus.tycho.TargetPlatform;
import org.codehaus.tycho.model.Platform;
import org.codehaus.tycho.osgitools.EquinoxBundleResolutionState;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestEclipseRuntime
extends AbstractLogEnabled
implements TargetPlatform {
    private Set<File> sites = new LinkedHashSet<File>();
    private ArrayList<File> bundles;
    private Properties properties = new Properties();
    private TargetPlatform sourcePlatform;
    private EquinoxBundleResolutionState resolver;
    private PlexusContainer plexus;
    private static final Map<String, Integer> START_LEVEL = new HashMap<String, Integer>();
    private File location;

    public void initialize() {
        this.bundles = new ArrayList();
        this.bundles.addAll(this.sourcePlatform.getArtifactFiles(new String[]{"eclipse-plugin", "eclipse-test-plugin"}));
        this.sites.addAll(this.sourcePlatform.getSites());
    }

    public List<File> getArtifactFiles(String ... types) {
        if (this.isBundle(types)) {
            return this.bundles;
        }
        return this.sourcePlatform.getArtifactFiles(types);
    }

    private boolean isBundle(String[] types) {
        for (String type : types) {
            if (!"eclipse-plugin".equals(type) && !"eclipse-test-plugin".equals(type)) continue;
            return true;
        }
        return false;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    private boolean shouldUseP2() {
        return this.resolver.getBundle("org.eclipse.equinox.simpleconfigurator", "highest version") != null;
    }

    private boolean shouldUseUpdateManager() {
        return this.resolver.getBundle("org.eclipse.update.configurator", "highest version") != null;
    }

    private void createBundlesInfoFile(File target) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (BundleDescription bundle : this.resolver.getBundles()) {
            File location = new File(bundle.getLocation());
            Manifest manifest = this.resolver.loadManifest(location);
            Attributes attributes = manifest.getMainAttributes();
            String version = attributes.getValue("Bundle-Version");
            sb.append(bundle.getSymbolicName()).append(',');
            sb.append(version).append(',');
            sb.append(location.toURL().toExternalForm()).append(',');
            Integer level = START_LEVEL.get(bundle.getSymbolicName());
            if (level != null) {
                sb.append(level).append(',');
                sb.append("true");
            } else {
                sb.append("4").append(',');
                sb.append("false");
            }
            sb.append('\n');
        }
        TestEclipseRuntime.fileWrite(new File(target, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info"), sb.toString());
    }

    private void createPlatformXmlFile(File work) throws IOException {
        Platform platform = new Platform();
        LinkedHashMap<String, ArrayList<String>> sitePlugins = new LinkedHashMap<String, ArrayList<String>>();
        LinkedHashMap siteFeatures = new LinkedHashMap();
        for (File bundle : this.bundles) {
            String siteUrl = this.getSiteUrl(bundle);
            if (siteUrl == null) {
                throw new RuntimeException("Can't determine site for bundle at " + bundle.getAbsolutePath());
            }
            ArrayList<String> plugins = (ArrayList<String>)sitePlugins.get(siteUrl);
            if (plugins == null) {
                plugins = new ArrayList<String>();
                sitePlugins.put(siteUrl, plugins);
            }
            plugins.add(this.getRelativeUrl(siteUrl, bundle));
        }
        LinkedHashSet sites = new LinkedHashSet();
        sites.addAll(sitePlugins.keySet());
        sites.addAll(siteFeatures.keySet());
        for (String siteUrl : sites) {
            Platform.Site site = new Platform.Site(siteUrl);
            site.setPlugins((List)sitePlugins.get(siteUrl));
            site.setFeatures((List)siteFeatures.get(siteUrl));
            platform.addSite(site);
        }
        Platform.write((Platform)platform, (File)new File(work, "configuration/org.eclipse.update/platform.xml"));
    }

    private String toOsgiBundles(List<BundleDescription> bundles) throws IOException {
        StringBuilder result = new StringBuilder();
        for (BundleDescription bundle : bundles) {
            Integer level = START_LEVEL.get(bundle.getSymbolicName());
            if (level != null && level == -1) continue;
            if (result.length() > 0) {
                result.append(",");
            }
            File file = new File(bundle.getLocation());
            result.append(this.appendAbsolutePath(file));
            if (level == null) continue;
            result.append('@').append(level).append(":start");
        }
        return result.toString();
    }

    private String appendAbsolutePath(File file) throws IOException {
        String url = file.getAbsolutePath().replace('\\', '/');
        return "reference:file:" + url;
    }

    private static void fileWrite(File file, String data) throws IOException {
        file.getParentFile().mkdirs();
        FileUtils.fileWrite((String)file.getAbsolutePath(), (String)data);
    }

    public void addBundle(File file) {
        this.bundles.add(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() {
        try {
            this.resolver = (EquinoxBundleResolutionState)this.plexus.lookup(BundleResolutionState.class);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Could not instantiate required component", e);
        }
        for (File file : this.bundles) {
            try {
                this.resolver.addBundle(file, true);
            }
            catch (BundleException e) {
                this.getLogger().debug("Exception resolving test runtime", (Throwable)e);
            }
        }
        try {
            Properties p = new Properties();
            String newOsgiBundles = this.toOsgiBundles(this.resolver.getBundles());
            p.setProperty("osgi.bundles", newOsgiBundles);
            p.setProperty("osgi.bundlefile.limit", "100");
            p.setProperty("osgi.install.area", "file:" + this.location.getAbsolutePath().replace('\\', '/'));
            p.setProperty("osgi.configuration.cascaded", "false");
            p.setProperty("osgi.framework", "org.eclipse.osgi");
            p.setProperty("osgi.bundles.defaultStartLevel", "4");
            String url = p.getProperty("osgi.framework");
            if (url != null) {
                BundleDescription desc = this.resolver.getBundle(url, "highest version");
                if (desc != null) {
                    url = "file:" + new File(desc.getLocation()).getAbsolutePath().replace('\\', '/');
                } else if (url.startsWith("file:")) {
                    String path = url.substring("file:".length());
                    File file = new File(path);
                    if (!file.isAbsolute()) {
                        file = new File(this.location, path);
                    }
                    url = "file:" + file.getAbsolutePath().replace('\\', '/');
                }
            }
            if (url != null) {
                p.setProperty("osgi.framework", url);
            }
            new File(this.location, "configuration").mkdir();
            FileOutputStream fos = new FileOutputStream(new File(this.location, "configuration/config.ini"));
            try {
                p.store(fos, null);
            }
            finally {
                fos.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception creating test eclipse runtime", e);
        }
    }

    public File getLocation() {
        return this.location;
    }

    public void setSourcePlatform(TargetPlatform sourcePlatform) {
        this.sourcePlatform = sourcePlatform;
    }

    public void setLocation(File location) {
        this.location = location;
    }

    public void setPlexusContainer(PlexusContainer plexus) {
        this.plexus = plexus;
    }

    private String getRelativeUrl(String siteUrl, File location) {
        String locationStr = this.toUrl(location);
        if (!locationStr.startsWith(siteUrl)) {
            throw new IllegalArgumentException();
        }
        return locationStr.substring(siteUrl.length());
    }

    private String toUrl(File file) {
        try {
            return file.getCanonicalFile().toURL().toExternalForm();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException", e);
        }
    }

    private String getSiteUrl(File location) {
        String locationStr = this.toUrl(location);
        for (File site : this.sites) {
            String siteUrl = this.toUrl(site);
            if (!locationStr.startsWith(siteUrl)) continue;
            return siteUrl;
        }
        return null;
    }

    public List<File> getSites() {
        return new ArrayList<File>(this.sites);
    }

    public BundleDescription getBundle(String symbolicName, String highestVersion) {
        return this.resolver.getBundle(symbolicName, highestVersion);
    }

    public BundleDescription getSystemBundle() {
        return this.resolver.getSystemBundle();
    }

    static {
        START_LEVEL.put("org.eclipse.equinox.common", 2);
        START_LEVEL.put("org.eclipse.core.runtime", 4);
        START_LEVEL.put("org.eclipse.equinox.simpleconfigurator", 1);
        START_LEVEL.put("org.eclipse.update.configurator", 3);
        START_LEVEL.put("org.eclipse.osgi", -1);
    }
}

