/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitest;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.Arg;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.tycho.osgitest.ConfigurationHelper;
import org.codehaus.tycho.osgitools.OsgiState;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMojo
extends AbstractMojo {
    private File work;
    private MavenProject project;
    private int debugPort;
    private List includes;
    private List excludes;
    private String test;
    private boolean skipExec;
    private boolean skip;
    private File testClassesDirectory;
    private File reportsDirectory;
    private File surefireProperties;
    private File devProperties;
    private OsgiState state;
    protected MavenProjectBuilder projectBuilder;
    MavenSession session;
    private boolean useUIHarness;
    private List<Artifact> pluginArtifacts;
    private String argLine;
    private int forkedProcessTimeoutInSeconds;
    private String testSuite;
    private String testClass;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File targetPlatform;
        if (this.skip || this.skipExec) {
            return;
        }
        if (this.testSuite != null || this.testClass != null) {
            if (this.testSuite == null || this.testClass == null) {
                throw new MojoExecutionException("Both testSuite and testClass must be provided or both should be null");
            }
            BundleDescription desc = this.state.getBundleDescription(this.testSuite, "highest version");
            MavenProject suite = this.state.getMavenProject(desc);
            if (suite == null) {
                throw new MojoExecutionException("Cannot find test suite project with Bundle-SymbolicName " + this.testSuite);
            }
            if (!suite.equals((Object)this.project)) {
                this.getLog().info((CharSequence)("Not executing tests, testSuite=" + this.testSuite + " and project is not the testSuite"));
                return;
            }
        }
        if ((targetPlatform = this.state.getTargetPlaform()) == null) {
            this.getLog().info((CharSequence)"Cannot determinate build target platform location -- not executing tests");
            return;
        }
        this.work.mkdirs();
        try {
            this.state.addBundle(this.getOsgiSurefireBooterPlugin());
        }
        catch (BundleException e) {
            throw new MojoExecutionException("Can't configure test runtime", (Exception)((Object)e));
        }
        new ConfigurationHelper(this.state).createConfiguration(this.work, targetPlatform, this.getTestBundles());
        this.createDevProperties();
        this.createSurefireProperties();
        this.reportsDirectory.mkdirs();
        String testBundle = null;
        boolean succeeded = this.runTest(targetPlatform, testBundle, this.test);
        if (!succeeded) {
            throw new MojoFailureException("There are test failures.\n\nPlease refer to " + this.reportsDirectory + " for the individual test results.");
        }
        this.getLog().info((CharSequence)"All tests passed!");
    }

    private Set<File> getTestBundles() throws MojoExecutionException {
        LinkedHashSet<File> testBundles = new LinkedHashSet<File>();
        for (BundleDescription bundle : this.getReactorBundles()) {
            this.addBundle(testBundles, bundle);
            for (BundleDescription fragment : bundle.getFragments()) {
                this.addBundle(testBundles, fragment);
            }
        }
        testBundles.add(this.getOsgiSurefireBooterPlugin());
        return testBundles;
    }

    private void addBundle(Set<File> testBundles, BundleDescription bundle) {
        MavenProject project = this.state.getMavenProject(bundle);
        if ("eclipse-test-plugin".equals(project.getPackaging())) {
            testBundles.add(project.getBasedir());
        } else if (project.getArtifact().getFile() != null) {
            testBundles.add(project.getArtifact().getFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSurefireProperties() throws MojoExecutionException {
        Properties p = new Properties();
        BundleDescription bundle = this.state.getBundleDescription(this.project);
        p.put("testpluginname", bundle.getSymbolicName());
        p.put("testclassesdirectory", this.testClassesDirectory.getAbsolutePath());
        p.put("reportsdirectory", this.reportsDirectory.getAbsolutePath());
        if (this.testClass != null) {
            p.put("includes", this.testClass.replace('.', '/') + ".class");
        } else {
            p.put("includes", this.includes != null ? this.getIncludesExcludes(this.includes) : "**/Test*.class,**/*Test.class,**/*TestCase.class");
            p.put("excludes", this.excludes != null ? this.getIncludesExcludes(this.excludes) : "**/Abstract*Test.class,**/Abstract*TestCase.class,**/*$*");
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.surefireProperties));
            try {
                p.store(out, null);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write test launcher properties file", (Exception)e);
        }
    }

    private String getIncludesExcludes(List<String> patterns) {
        StringBuilder sb = new StringBuilder();
        for (String pattern : patterns) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(pattern);
        }
        return sb.toString();
    }

    private boolean runTest(File targetPlatform, String testBundle, String className) throws MojoExecutionException {
        int result;
        try {
            String workspace = new File(this.work, "data").getAbsolutePath();
            FileUtils.deleteDirectory((String)workspace);
            Commandline cli = new Commandline();
            cli.setWorkingDirectory(this.project.getBasedir());
            String executable = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            if (File.separatorChar == '\\') {
                executable = executable + ".exe";
            }
            cli.setExecutable(executable);
            if (this.debugPort > 0) {
                cli.addArguments(new String[]{"-Xdebug", "-Xrunjdwp:transport=dt_socket,address=" + this.debugPort + ",server=y,suspend=y"});
            }
            cli.addArguments(new String[]{"-Dosgi.noShutdown=false"});
            if (this.argLine != null) {
                Arg arg = cli.createArg();
                arg.setLine(this.argLine);
            }
            cli.addArguments(new String[]{"-jar", this.getEclipseLauncher().getAbsolutePath()});
            if (this.getLog().isDebugEnabled()) {
                cli.addArguments(new String[]{"-debug", "-consolelog"});
            }
            cli.addArguments(new String[]{"-data", workspace, "-dev", this.devProperties.toURI().toURL().toExternalForm(), "-install", targetPlatform.getAbsolutePath(), "-configuration", new File(this.work, "configuration").getAbsolutePath(), "-application", this.getTestApplication(), "-testproperties", this.surefireProperties.getAbsolutePath()});
            this.getLog().info((CharSequence)("Expected eclipse log file: " + new File(workspace, ".metadata/.log").getCanonicalPath()));
            this.getLog().info((CharSequence)("Command line:\n\t" + cli.toString()));
            StreamConsumer out = new StreamConsumer(){

                public void consumeLine(String line) {
                    System.out.println(line);
                }
            };
            StreamConsumer err = new StreamConsumer(){

                public void consumeLine(String line) {
                    System.err.println(line);
                }
            };
            result = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err, (int)this.forkedProcessTimeoutInSeconds);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while executing platform", e);
        }
        return result == 0;
    }

    private String getTestApplication() {
        if (this.useUIHarness) {
            Version osgiVersion = this.getPlatformVersion();
            if (osgiVersion.getMajor() == 3 && osgiVersion.getMinor() == 2) {
                return "org.codehaus.tycho.surefire.osgibooter.uitest32";
            }
            return "org.codehaus.tycho.surefire.osgibooter.uitest";
        }
        return "org.codehaus.tycho.surefire.osgibooter.headlesstest";
    }

    private File getEclipseLauncher() throws IOException {
        Version osgiVersion = this.getPlatformVersion();
        if (osgiVersion.getMajor() == 3 && osgiVersion.getMinor() == 2) {
            return new File(this.state.getTargetPlaform(), "startup.jar").getCanonicalFile();
        }
        BundleDescription launcher = this.state.getBundleDescription("org.eclipse.equinox.launcher", "highest version");
        return new File(launcher.getLocation()).getCanonicalFile();
    }

    private Version getPlatformVersion() {
        BundleDescription osgi = this.state.getBundleDescription("org.eclipse.osgi", "highest version");
        return osgi.getVersion();
    }

    private File getOsgiSurefireBooterPlugin() throws MojoExecutionException {
        for (Artifact artifact : this.pluginArtifacts) {
            if (!"org.codehaus.tycho".equals(artifact.getGroupId()) || !"tycho-surefire-osgi-booter".equals(artifact.getArtifactId())) continue;
            return artifact.getFile();
        }
        throw new MojoExecutionException("Unable to locate org.codehaus.tycho:tycho-surefire-osgi-booter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDevProperties() throws MojoExecutionException {
        Properties dev = new Properties();
        for (BundleDescription bundle : this.getReactorBundles()) {
            MavenProject project = this.state.getMavenProject(bundle);
            if (!"eclipse-test-plugin".equals(project.getPackaging())) continue;
            Build build = project.getBuild();
            dev.put(bundle.getSymbolicName(), build.getOutputDirectory() + "," + build.getTestOutputDirectory());
        }
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.devProperties));
            try {
                dev.store(os, null);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't create osgi dev properties file", (Exception)e);
        }
    }

    private Set<BundleDescription> getReactorBundles() {
        LinkedHashSet<BundleDescription> reactorBundles = new LinkedHashSet<BundleDescription>();
        reactorBundles.add(this.state.getBundleDescription(this.project));
        for (BundleDescription desc : this.state.getBundles()) {
            MavenProject project = this.state.getMavenProject(desc);
            if (project == null) continue;
            reactorBundles.add(desc);
        }
        return reactorBundles;
    }
}

