/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.tycho.osgitools.OsgiState;
import org.eclipse.osgi.service.resolver.BundleDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationHelper {
    private final OsgiState state;

    ConfigurationHelper(OsgiState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConfiguration(File work, File targetPlatform, Set<File> testBundles) throws MojoExecutionException {
        try {
            Properties p = new Properties();
            FileInputStream fis = new FileInputStream(new File(targetPlatform, "configuration/config.ini"));
            try {
                p.load(fis);
            }
            finally {
                fis.close();
            }
            String osgiBundles = p.getProperty("osgi.bundles");
            String newOsgiBundles = this.createOsgiBundlesProperty(targetPlatform, osgiBundles, testBundles);
            p.setProperty("osgi.bundles", newOsgiBundles);
            p.setProperty("org.eclipse.equinox.simpleconfigurator.exclusiveInstallation", "false");
            ConfigurationHelper.addRequiredProperties(p, targetPlatform);
            String url = p.getProperty("osgi.framework");
            if (url != null) {
                BundleDescription desc = this.state.getBundleDescription(url, "highest version");
                if (desc != null) {
                    url = "file:" + new File(desc.getLocation()).getAbsolutePath().replace('\\', '/');
                } else if (url.startsWith("file:")) {
                    String path = url.substring("file:".length());
                    File file = new File(path);
                    if (!file.isAbsolute()) {
                        file = new File(targetPlatform, path);
                    }
                    url = "file:" + file.getAbsolutePath().replace('\\', '/');
                }
            }
            if (url != null) {
                p.setProperty("osgi.framework", url);
            }
            new File(work, "configuration").mkdir();
            FileOutputStream fos = new FileOutputStream(new File(work, "configuration/config.ini"));
            try {
                p.store(fos, null);
            }
            finally {
                fos.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception creating config.ini", (Exception)e);
        }
    }

    private String createOsgiBundlesProperty(File targetPlatform, String osgiBundles, Set<File> testPlugins) throws IOException, MojoExecutionException {
        StringBuilder result = new StringBuilder();
        StringTokenizer st = new StringTokenizer(osgiBundles, ",");
        while (st.hasMoreTokens()) {
            String t;
            int at;
            String url;
            if (result.length() > 0) {
                result.append(",");
            }
            if ((url = this.getPlatformURL(targetPlatform, (at = (t = st.nextToken().trim()).indexOf(64)) > 0 ? t.substring(0, at) : t)) != null) {
                result.append(url);
                if (at <= 0) continue;
                result.append(t.substring(at));
                continue;
            }
            result.append(t);
        }
        for (File file : testPlugins) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(this.appendAbsolutePath(file));
        }
        return result.toString();
    }

    private String appendAbsolutePath(File file) throws IOException {
        String url = file.getAbsolutePath().replace('\\', '/');
        return "reference:file:" + url;
    }

    private String getPlatformURL(File targetPlatform, String id) throws IOException {
        String path;
        BundleDescription desc = this.state.getBundleDescription(id, "highest version");
        if (desc != null) {
            return this.appendAbsolutePath(new File(desc.getLocation()));
        }
        if (id.startsWith("reference:file:") && !new File(path = id.substring("reference:file:".length())).isAbsolute()) {
            return this.appendAbsolutePath(new File(targetPlatform, "plugins/" + path));
        }
        return null;
    }

    private static void addRequiredProperties(Properties properties, File targetPlatform) {
        if (!properties.containsKey("osgi.install.area")) {
            properties.setProperty("osgi.install.area", "file:" + targetPlatform.getAbsolutePath().replace('\\', '/'));
        }
        if (!properties.containsKey("osgi.configuration.cascaded")) {
            properties.setProperty("osgi.configuration.cascaded", "true");
        }
        if (!properties.containsKey("osgi.framework")) {
            properties.setProperty("osgi.framework", "org.eclipse.osgi");
        }
        if (!properties.containsKey("osgi.bundles.defaultStartLevel")) {
            properties.setProperty("osgi.bundles.defaultStartLevel", "4");
        }
    }
}

