/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import java.io.File;
import java.io.IOException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.tycho.BundleResolutionState;
import org.codehaus.tycho.FeatureResolutionState;
import org.codehaus.tycho.TychoConstants;
import org.sonatype.tycho.osgi.EquinoxEmbedder;
import org.sonatype.tycho.p2.facade.P2Generator;

public abstract class AbstractTychoPackagingMojo
extends AbstractMojo {
    protected MavenSession session;
    protected MavenProject project;
    protected boolean attachP2Metadata;
    protected PlexusContainer plexus;
    private EquinoxEmbedder equinox;
    protected FeatureResolutionState featureResolutionState;
    protected BundleResolutionState bundleResolutionState;
    private P2Generator p2;
    protected MavenProjectHelper projectHelper;

    protected void initializeProjectContext() {
        this.featureResolutionState = (FeatureResolutionState)this.project.getContextValue(TychoConstants.CTX_FEATURE_RESOLUTION_STATE);
        this.bundleResolutionState = (BundleResolutionState)this.project.getContextValue(TychoConstants.CTX_BUNDLE_RESOLUTION_STATE);
    }

    protected P2Generator getP2Generator() {
        if (this.p2 == null) {
            this.p2 = (P2Generator)this.equinox.getService(P2Generator.class);
            if (this.p2 == null) {
                throw new IllegalStateException("Could not acquire P2 metadata service");
            }
        }
        return this.p2;
    }

    protected void attachP2Metadata() throws MojoExecutionException {
        if (!this.attachP2Metadata) {
            return;
        }
        File file = this.project.getArtifact().getFile();
        if (file == null || !file.canRead()) {
            throw new IllegalStateException();
        }
        File content = new File(this.project.getBuild().getDirectory(), "p2content.xml");
        File artifacts = new File(this.project.getBuild().getDirectory(), "p2artifacts.xml");
        try {
            this.getP2Generator().generateMetadata(file, this.project.getPackaging(), this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), content, artifacts);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not generate P2 metadata", (Exception)e);
        }
        this.projectHelper.attachArtifact(this.project, "xml", "p2metadata", content);
        this.projectHelper.attachArtifact(this.project, "xml", "p2artifacts", artifacts);
    }
}

