/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.sonatype.tycho.osgi.EquinoxEmbedder;

public class P2MetadataMojo
extends AbstractMojo {
    protected MavenProject project;
    private String metadataRepositoryName;
    private File target;
    private String artifactRepositoryName;
    private int forkedProcessTimeoutInSeconds;
    private String argLine;
    private EquinoxEmbedder p2;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.generateMetadata();
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot generate P2 metadata", e);
        }
    }

    private void generateMetadata() throws Exception {
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(this.project.getBasedir());
        String executable = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        if (File.separatorChar == '\\') {
            executable = executable + ".exe";
        }
        cli.setExecutable(executable);
        cli.addArguments(new String[]{"-jar", this.getEquinoxLauncher().getAbsolutePath()});
        cli.addArguments(new String[]{"-nosplash", "-application", "org.eclipse.equinox.p2.metadata.generator.EclipseGenerator", "-updateSite", this.getUpdateSiteLocation().getCanonicalPath(), "-site", new File(this.getUpdateSiteLocation(), "site.xml").toURL().toExternalForm(), "-metadataRepository", this.getUpdateSiteLocation().toURL().toExternalForm(), "-metadataRepositoryName", this.metadataRepositoryName, "-artifactRepository", this.getUpdateSiteLocation().toURL().toExternalForm(), "-artifactRepositoryName", this.artifactRepositoryName, "-noDefaultIUs", "-vmargs", this.argLine});
        this.getLog().info((CharSequence)("Command line:\n\t" + cli.toString()));
        StreamConsumer out = new StreamConsumer(){

            public void consumeLine(String line) {
                System.out.println(line);
            }
        };
        StreamConsumer err = new StreamConsumer(){

            public void consumeLine(String line) {
                System.err.println(line);
            }
        };
        int result = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err, (int)this.forkedProcessTimeoutInSeconds);
        if (result != 0) {
            throw new MojoFailureException("P2 return code was " + result);
        }
    }

    private File getUpdateSiteLocation() {
        return this.target;
    }

    private File getEquinoxLauncher() throws MojoFailureException {
        File p2location = this.p2.getRuntimeLocation();
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(p2location);
        ds.setIncludes(new String[]{"plugins/org.eclipse.equinox.launcher_*.jar"});
        ds.scan();
        String[] includedFiles = ds.getIncludedFiles();
        if (includedFiles == null || includedFiles.length != 1) {
            throw new MojoFailureException("Can't locate org.eclipse.equinox.launcher bundle in " + p2location);
        }
        return new File(p2location, includedFiles[0]);
    }
}

