/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import aQute.lib.osgi.Instruction;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.osgi.DefaultMaven2OsgiConverter;
import org.apache.maven.shared.osgi.Maven2OsgiConverter;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.tycho.utils.ArtifactRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateBundleMojo
extends AbstractMojo
implements Contextualizable {
    private MavenProject project;
    private MavenSession session;
    private String exportPackages;
    private File buildTarget;
    private Map manifestAttributes;
    private String jars = "jars";
    private boolean packageSources = true;
    private ArrayList<Artifact> inlcudedArtifacts;
    private ArtifactFactory artifactFactory;
    private ProjectBuilder projectBuilder;
    private MavenProjectHelper projectHelper;
    private ArtifactResolver resolver;
    private PlexusContainer plexus;
    private ArtifactRef[] exclusions;
    private ArtifactRef[] requireBundles;
    private String classifier;
    private String projectJar = null;
    private String[] bundleClasspath;
    private String organization;
    private static final Maven2OsgiConverter mavenOsgi = new DefaultMaven2OsgiConverter();
    private static final SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmm");

    public void execute() throws MojoExecutionException {
        try {
            File out = new File(this.project.getBasedir(), this.jars);
            for (Artifact a : this.getIncludedArtifacts()) {
                FileUtils.copyFileToDirectory((File)a.getFile(), (File)out);
            }
            if (this.packageSources) {
                this.packageSources(this.getIncludedArtifacts());
            }
            Manifest manifest = this.getManifest();
            File metaInf = new File(this.project.getBasedir(), "META-INF");
            metaInf.mkdirs();
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(metaInf, "MANIFEST.MF")));
            manifest.write(os);
            os.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void packageBundle() throws Exception {
        File jar = null;
        File outputDirectory = new File(this.project.getBuild().getOutputDirectory());
        if (this.projectJar != null && outputDirectory.exists()) {
            JarArchiver jarer = (JarArchiver)this.plexus.lookup(JarArchiver.ROLE, "jar");
            jar = new File(this.project.getBasedir(), this.jars + "/" + this.projectJar);
            jarer.setDestFile(jar);
            jarer.addDirectory(outputDirectory);
            jarer.createArchive();
        }
        File file = new File(this.buildTarget, this.project.getBuild().getFinalName() + ".jar");
        JarArchiver archiver = (JarArchiver)this.plexus.lookup(JarArchiver.ROLE, "jar");
        archiver.setDestFile(file);
        File mfile = this.expandVersion(new File(this.project.getBasedir(), "META-INF/MANIFEST.MF"));
        archiver.setManifest(mfile);
        if (jar != null) {
            archiver.addFile(jar, this.jars + "/" + jar.getName());
        }
        for (Artifact d : this.getIncludedArtifacts()) {
            archiver.addFile(d.getFile(), this.jars + "/" + d.getFile().getName());
        }
        if (this.bundleClasspath != null) {
            for (int i = 0; i < this.bundleClasspath.length; ++i) {
                archiver.addFile(new File(this.project.getBasedir(), this.bundleClasspath[i]), this.bundleClasspath[i]);
            }
        }
        archiver.createArchive();
        this.project.getArtifact().setFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File expandVersion(File mfile) throws FileNotFoundException, IOException {
        Manifest mf;
        FileInputStream is = new FileInputStream(mfile);
        try {
            mf = new Manifest(is);
        }
        finally {
            is.close();
        }
        if (this.expandVersion(mf)) {
            mfile = new File(this.project.getBuild().getDirectory(), "MANIFEST.MF");
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(mfile));
            try {
                mf.write(os);
            }
            finally {
                os.close();
            }
        }
        return mfile;
    }

    private boolean expandVersion(Manifest mf) {
        Attributes attributes = mf.getMainAttributes();
        String version = attributes.getValue("Bundle-Version");
        if (version.endsWith(".qualifier")) {
            version = version.substring(0, version.lastIndexOf(46) + 1);
            version = version + df.format(new Date());
            attributes.putValue("Bundle-Version", version);
            return true;
        }
        return false;
    }

    private void packageSources(List includedArtifacts) throws Exception {
    }

    public Manifest getManifest() throws MojoExecutionException {
        String requiredBundles;
        Manifest m = new Manifest();
        Attributes attributes = m.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.putValue("Bundle-ManifestVersion", "2");
        Artifact artifact = this.project.getArtifact();
        attributes.putValue("Bundle-Version", this.getBundleVersion(artifact, true));
        attributes.putValue("Bundle-Name", this.project.getName());
        String symbolicName = (String)this.manifestAttributes.get("Bundle-SymbolicName");
        if (symbolicName == null) {
            symbolicName = this.getBundleSymbolicName(artifact.getGroupId(), artifact.getArtifactId()) + ";singleton:=true";
        }
        attributes.putValue("Bundle-SymbolicName", symbolicName);
        if (this.organization != null) {
            attributes.putValue("Bundle-Vendor", this.organization);
        }
        attributes.putValue("Bundle-ClassPath", this.getBundleClasspath());
        String exportedPackages = this.getExportedPackages();
        if (exportedPackages != null) {
            attributes.putValue("Export-Package", exportedPackages);
        }
        if ((requiredBundles = this.getRequiredBundles()) != null) {
            attributes.putValue("Require-Bundle", requiredBundles);
        }
        if (this.manifestAttributes != null) {
            for (Map.Entry e : this.manifestAttributes.entrySet()) {
                attributes.putValue((String)e.getKey(), (String)e.getValue());
            }
        }
        attributes.putValue("MavenArtifact-GroupId", this.project.getGroupId());
        attributes.putValue("MavenArtifact-ArtifactId", this.project.getArtifactId());
        attributes.putValue("MavenArtifact-BaseVersion", artifact.getBaseVersion());
        return m;
    }

    private String getRequiredBundles() {
        StringBuffer sb = new StringBuffer();
        String requireBundle = (String)this.manifestAttributes.get("Require-Bundle");
        if (requireBundle != null) {
            sb.append(requireBundle);
        }
        if (this.requireBundles != null) {
            for (int i = 0; i < this.requireBundles.length; ++i) {
                ArtifactRef a = this.requireBundles[i];
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(this.getBundleSymbolicName(a.getGroupId(), a.getArtifactId()));
            }
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    private String getExportedPackages() throws MojoExecutionException {
        if (this.exportPackages == null) {
            return null;
        }
        HashSet allpackages = new HashSet();
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        StringTokenizer st = new StringTokenizer(this.exportPackages, ",");
        while (st.hasMoreTokens()) {
            instructions.add(Instruction.getPattern((String)st.nextToken().trim()));
        }
        try {
            File classes = new File(this.project.getBuild().getOutputDirectory());
            if (classes.exists()) {
                this.addExportedPackages(allpackages, instructions, classes);
            }
            for (Artifact a : this.getIncludedArtifacts()) {
                File f = a.getFile();
                this.addExportedPackages(allpackages, instructions, f);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        StringBuffer sb = new StringBuffer();
        for (String pkg : allpackages) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(pkg);
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExportedPackages(Set allpackages, ArrayList instructions, File file) throws ZipException, IOException {
        if (file.isDirectory()) {
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(file);
            ds.setIncludes(new String[]{"**"});
            ds.scan();
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                String pkg = GenerateBundleMojo.getPackage(files[i]);
                if (pkg == null || this.excluded(instructions, pkg)) continue;
                allpackages.add(pkg);
            }
        } else {
            ZipFile zip = new ZipFile(file);
            try {
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String pkg = GenerateBundleMojo.getPackage(entry.getName());
                    if (pkg == null || this.excluded(instructions, pkg)) continue;
                    allpackages.add(pkg);
                }
            }
            finally {
                zip.close();
            }
        }
    }

    private boolean excluded(ArrayList instructions, String pkg) {
        for (Instruction f : instructions) {
            if (!f.matches(pkg)) continue;
            return f.isNegated();
        }
        return true;
    }

    private static String getPackage(String name) {
        int idx = (name = name.replace('\\', '/')).lastIndexOf(47);
        if (idx <= 0 || name.endsWith("/")) {
            return null;
        }
        String dirname = name.substring(0, idx);
        if (dirname.indexOf(46) > -1) {
            return null;
        }
        return dirname.replace('/', '.');
    }

    String getBundleClasspath() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        File outputDirectory = new File(this.project.getBuild().getOutputDirectory());
        if (outputDirectory.exists()) {
            if (this.classifier != null) {
                for (Artifact a : this.project.getAttachedArtifacts()) {
                    if (!this.classifier.equals(a.getClassifier())) continue;
                    sb.append(this.jars + "/" + a.getFile().getName());
                }
            } else if (this.projectJar != null) {
                sb.append(this.jars + "/" + this.projectJar);
            }
        }
        if (this.bundleClasspath != null) {
            for (int i = 0; i < this.bundleClasspath.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(this.bundleClasspath[i]);
            }
        }
        for (Artifact a : this.getIncludedArtifacts()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(this.jars + "/" + a.getFile().getName());
        }
        return sb.toString();
    }

    String getBundleVersion(Artifact a, boolean pde) {
        String suffix;
        String version = mavenOsgi.getVersion(a);
        if (version.endsWith(suffix = ".SNAPSHOT")) {
            version = version.substring(0, version.length() - suffix.length());
            version = pde ? version + ".qualifier" : version + "-" + df.format(new Date());
        }
        return version;
    }

    String getBundleSymbolicName(String groupId, String artifactId) {
        String name = artifactId;
        return name.replace('-', '_');
    }

    private Set<String> getImportedArtifactKeys() throws MojoExecutionException {
        HashSet<String> result = new HashSet<String>();
        ArtifactRepository localRepository = this.session.getLocalRepository();
        List remoteRepositories = this.project.getRemoteArtifactRepositories();
        if (this.requireBundles != null) {
            for (int i = 0; i < this.requireBundles.length; ++i) {
                ArtifactRef a = this.requireBundles[i];
                result.add(this.getArtifactKey(a.getGroupId(), a.getArtifactId()));
                try {
                    Artifact pomArtifact = this.artifactFactory.createArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), "pom", "pom");
                    this.resolver.resolve(pomArtifact, remoteRepositories, localRepository);
                    FileUtils.copyFileToDirectory((File)pomArtifact.getFile(), (File)this.buildTarget);
                    DefaultProjectBuilderConfiguration pbc = new DefaultProjectBuilderConfiguration();
                    pbc.setLocalRepository(localRepository);
                    MavenProject pomProject = this.projectBuilder.buildProjectWithDependencies(new File(this.buildTarget, pomArtifact.getFile().getName()), (ProjectBuildingRequest)pbc).getProject();
                    for (Artifact b : pomProject.getArtifacts()) {
                        result.add(this.getArtifactKey(b.getGroupId(), b.getArtifactId()));
                    }
                    continue;
                }
                catch (AbstractArtifactResolutionException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                catch (ProjectBuildingException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                }
            }
        }
        return result;
    }

    private String getArtifactKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public List<Artifact> getIncludedArtifacts() throws MojoExecutionException {
        if (this.inlcudedArtifacts == null) {
            this.inlcudedArtifacts = new ArrayList();
            HashSet<String> exclusionKeys = new HashSet<String>();
            if (this.exclusions != null) {
                for (int i = 0; i < this.exclusions.length; ++i) {
                    exclusionKeys.add(this.getArtifactKey(this.exclusions[i].getGroupId(), this.exclusions[i].getArtifactId()));
                }
            }
            exclusionKeys.addAll(this.getImportedArtifactKeys());
            for (Artifact a : this.project.getArtifacts()) {
                if (exclusionKeys.contains(this.getArtifactKey(a.getGroupId(), a.getArtifactId()))) continue;
                this.inlcudedArtifacts.add(a);
            }
        }
        return this.inlcudedArtifacts;
    }

    public void contextualize(Context ctx) throws ContextException {
        this.plexus = (PlexusContainer)ctx.get((Object)"plexus");
    }
}

