/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.tycho.eclipsepackaging.AbstractTychoPackagingMojo;
import org.codehaus.tycho.eclipsepackaging.VersioningHelper;
import org.codehaus.tycho.osgitools.project.BuildOutputJar;
import org.codehaus.tycho.osgitools.project.EclipsePluginProject;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Version;

public class PackagePluginMojo
extends AbstractTychoPackagingMojo {
    protected File buildDirectory;
    protected EclipsePluginProject pdeProject;
    private JarArchiver jarArchiver = new JarArchiver();
    protected String finalName;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    protected String qualifier;

    public void execute() throws MojoExecutionException {
        this.initializeProjectContext();
        this.pdeProject = this.tychoSession.getEclipsePluginProject(this.project);
        this.createSubJars();
        File pluginFile = this.createPluginJar();
        this.project.getArtifact().setFile(pluginFile);
        this.attachP2Metadata();
    }

    private void createSubJars() throws MojoExecutionException {
        for (BuildOutputJar jar : this.pdeProject.getOutputJars()) {
            if (".".equals(jar.getName())) continue;
            this.makeJar(jar.getName(), jar.getOutputDirectory());
        }
    }

    private File makeJar(String jarName, File classesFolder) throws MojoExecutionException {
        try {
            File jarFile = new File(this.project.getBasedir(), jarName);
            JarArchiver archiver = new JarArchiver();
            archiver.setDestFile(jarFile);
            archiver.addDirectory(classesFolder);
            archiver.createArchive();
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not create jar " + jarName, e);
        }
    }

    private File createPluginJar() throws MojoExecutionException {
        try {
            File manifest;
            BuildOutputJar dotOutputJar;
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            File pluginFile = new File(this.buildDirectory, this.finalName + ".jar");
            if (pluginFile.exists()) {
                pluginFile.delete();
            }
            if ((dotOutputJar = this.pdeProject.getDotOutputJar()) != null) {
                archiver.getArchiver().addDirectory(dotOutputJar.getOutputDirectory());
            }
            String binIncludes = this.pdeProject.getBuildProperties().getProperty("bin.includes");
            String binExcludes = this.pdeProject.getBuildProperties().getProperty("bin.excludes");
            if (binIncludes != null) {
                archiver.getArchiver().addDirectory(this.project.getBasedir(), this.toFilePattern(binIncludes), this.toFilePattern(binExcludes));
            }
            if ((manifest = this.updateManifest()).exists()) {
                this.archive.setManifestFile(manifest);
            }
            archiver.setOutputFile(pluginFile);
            archiver.createArchive(this.project, this.archive);
            return pluginFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling JAR", e);
        }
    }

    private String[] toFilePattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        return pattern.split(",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File updateManifest() throws FileNotFoundException, IOException, MojoExecutionException {
        Manifest mf;
        BundleDescription bundle = this.bundleResolutionState.getBundleByLocation(this.project.getBasedir());
        Version version = bundle.getVersion();
        File mfile = new File(this.project.getBasedir(), "META-INF/MANIFEST.MF");
        FileInputStream is = new FileInputStream(mfile);
        try {
            mf = new Manifest(is);
        }
        finally {
            ((InputStream)is).close();
        }
        Attributes attributes = mf.getMainAttributes();
        if (VersioningHelper.isSnapshotVersion(version)) {
            String expandedVersion = VersioningHelper.expandVersion(version, this.qualifier).toString();
            attributes.putValue("Bundle-Version", expandedVersion);
            VersioningHelper.setExpandedVersion(this.tychoSession, bundle.getLocation(), expandedVersion);
        }
        attributes.putValue("MavenArtifact-GroupId", this.project.getGroupId());
        attributes.putValue("MavenArtifact-BaseVersion", this.project.getVersion());
        mfile = new File(this.project.getBuild().getDirectory(), "MANIFEST.MF");
        mfile.getParentFile().mkdirs();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(mfile));
        try {
            mf.write(os);
        }
        finally {
            os.close();
        }
        return mfile;
    }
}

