/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class DeploySourceMojo
extends AbstractMojo {
    private MavenProject project;
    protected ArtifactInstaller installer;
    protected List remoteArtifactRepositories;
    protected ArtifactRepository localRepository;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    private File work;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (Artifact a : this.project.getDependencyArtifacts()) {
            try {
                this.processArtifact(a);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Could not resolve: " + a);
            }
            catch (ArtifactNotFoundException e) {
                throw new MojoExecutionException("Could not find: " + a);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error processing: " + a);
            }
            catch (ArtifactInstallationException e) {
                throw new MojoExecutionException("Error installing: " + a);
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Error creating jar: " + a);
            }
        }
    }

    private void processArtifact(Artifact a) throws IOException, ArtifactResolutionException, ArtifactNotFoundException, ArtifactInstallationException, ArchiverException {
        JarFile jar;
        Manifest mft;
        String classPath;
        if (!a.isResolved()) {
            this.artifactResolver.resolve(a, this.remoteArtifactRepositories, this.localRepository);
        }
        if ((classPath = (mft = (jar = new JarFile(a.getFile())).getManifest()).getMainAttributes().getValue("Bundle-ClassPath")) == null) {
            classPath = ".";
        }
        if (classPath.equals(".")) {
            JarEntry je = jar.getJarEntry("src.zip");
            if (je != null) {
                File target = File.createTempFile("deploysource", "jar");
                this.extractEntry(jar.getInputStream(je), target);
                this.deploySourceArtifact(a, target);
            }
        } else {
            String[] libs = classPath.split(",");
            File targetDir = new File(this.work, a.getArtifactId());
            targetDir.mkdirs();
            for (int i = 0; i < libs.length; ++i) {
                String lib = libs[i];
                String srcName = lib.endsWith(".jar") ? lib.substring(0, lib.length() - 4) + "src.zip" : "src.zip";
                JarEntry je = jar.getJarEntry(srcName);
                if (je == null) continue;
                File target = new File(targetDir, srcName);
                this.extractEntry(jar.getInputStream(je), target);
            }
            jar.close();
            JarArchiver jarArchiver = new JarArchiver();
            jarArchiver.addDirectory(targetDir, new String[]{"**/*"}, new String[0]);
            File f = File.createTempFile("deploysource", ".jar");
            jarArchiver.setDestFile(f);
            jarArchiver.createArchive();
            this.deploySourceArtifact(a, f);
        }
    }

    private void deploySourceArtifact(Artifact artifact, File sourceFile) throws ArtifactInstallationException {
        Artifact sourceArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "jar", "sources");
        this.installer.install(sourceFile, sourceArtifact, this.localRepository);
        this.getLog().info((CharSequence)("Artifact source installed: " + artifact));
    }

    private void extractEntry(InputStream is, File target) throws IOException {
        byte[] jbuf = new byte[8192];
        FileOutputStream os = new FileOutputStream(target);
        int n = 0;
        while ((n = is.read(jbuf)) > 0) {
            os.write(jbuf, 0, n);
        }
        is.close();
        os.close();
    }
}

