/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.buildnumber;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class BuildQualifierMojo
extends AbstractMojo {
    public static final String BUILD_QUALIFIER_PROPERTY = "buildQualifier";
    private static final String REACTOR_BUILD_TIMESTAMP_PROPERTY = "reactorBuildTimestampProperty";
    private MavenSession session;
    private String buildNumberPropertyName;
    private SimpleDateFormat format;
    private MavenProject project;
    private File buildProperties;
    private String forceContextQualifier;

    public void setFormat(String format) {
        this.format = new SimpleDateFormat(format);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String qualifier = this.forceContextQualifier;
        if (qualifier == null) {
            qualifier = this.getBuildProperties().getProperty("forceContextQualifier");
        }
        if (qualifier == null) {
            Date timestamp = this.getSessionTimestamp();
            qualifier = this.format.format(timestamp);
        }
        this.project.getProperties().put(BUILD_QUALIFIER_PROPERTY, qualifier);
    }

    private Date getSessionTimestamp() {
        Date timestamp;
        String value = this.session.getExecutionProperties().getProperty(this.buildNumberPropertyName);
        if (value != null) {
            timestamp = new Date(Long.parseLong(value));
        } else {
            timestamp = new Date();
            this.session.getExecutionProperties().setProperty(REACTOR_BUILD_TIMESTAMP_PROPERTY, Long.toString(timestamp.getTime()));
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getBuildProperties() {
        Properties props;
        block5: {
            props = new Properties();
            try {
                if (!this.buildProperties.canRead()) break block5;
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.buildProperties));
                try {
                    props.load(is);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Exception reading build.properties file", (Throwable)e);
            }
        }
        return props;
    }
}

