/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import de.schlichtherle.io.FileInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.ArchiveEntryUtils;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.model.PluginRef;
import org.codehaus.tycho.model.ProductConfiguration;
import org.codehaus.tycho.osgitools.OsgiState;
import org.codehaus.tycho.osgitools.features.FeatureDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductExportMojo
extends AbstractMojo
implements Contextualizable {
    private PlexusContainer plexus;
    private OsgiState state;
    protected MavenProject project;
    protected String qualifier;
    private File target;
    private File pluginsFolder;
    private File featuresFolder;
    private File productConfigurationFile;
    private ProductConfiguration productConfiguration;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File basedir;
        File productCfg;
        if (this.productConfigurationFile == null && (productCfg = new File(basedir = this.project.getBasedir(), this.project.getArtifactId() + ".product")).exists()) {
            this.productConfigurationFile = productCfg;
        }
        if (this.productConfigurationFile == null) {
            throw new MojoExecutionException("Product configuration file not expecified");
        }
        if (!this.productConfigurationFile.exists()) {
            throw new MojoExecutionException("Product configuration file not found " + this.productConfigurationFile.getAbsolutePath());
        }
        try {
            this.getLog().debug((CharSequence)"Parsing productConfiguration");
            this.productConfiguration = ProductConfiguration.read((File)this.productConfigurationFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading product configuration file", (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing product configuration file", (Exception)((Object)e));
        }
        this.generateEclipseProduct();
        this.generateConfigIni();
        this.pluginsFolder.mkdirs();
        if (this.productConfiguration.getUseFeatures().booleanValue()) {
            this.featuresFolder.mkdirs();
            this.copyFeatures(this.productConfiguration.getFeatures());
        } else {
            this.copyPlugins(this.productConfiguration.getPlugins());
        }
        this.copyExecutable();
        this.packProduct();
    }

    private void packProduct() throws MojoExecutionException {
        ZipArchiver zipper;
        try {
            zipper = (ZipArchiver)this.plexus.lookup(ZipArchiver.ROLE, "zip");
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Unable to resolve ZipArchiver", (Exception)((Object)e));
        }
        File destFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".zip");
        try {
            zipper.addDirectory(this.target);
            zipper.setDestFile(destFile);
            zipper.createArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error packing product", e);
        }
        this.project.getArtifact().setFile(destFile);
    }

    private boolean isEclipse32Platform() {
        Version osgiVersion = this.state.getPlatformVersion();
        return osgiVersion.getMajor() == 3 && osgiVersion.getMinor() == 2;
    }

    private void generateEclipseProduct() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Generating .eclipseproduct");
        Properties props = new Properties();
        this.setPropertyIfNotNull(props, "version", this.productConfiguration.getVersion());
        this.setPropertyIfNotNull(props, "name", this.productConfiguration.getName());
        this.setPropertyIfNotNull(props, "id", this.productConfiguration.getId());
        this.target.mkdirs();
        File eclipseproduct = new File(this.target, ".eclipseproduct");
        try {
            FileOutputStream fos = new FileOutputStream(eclipseproduct);
            props.store(fos, "Eclipse Product File");
            fos.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating .eclipseproduct file.", (Exception)e);
        }
    }

    private void generateConfigIni() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Generating config.ini");
        Properties props = new Properties();
        String splash = this.productConfiguration.getId().split("\\.")[0];
        this.setPropertyIfNotNull(props, "osgi.splashPath", "platform:/base/plugins/" + splash);
        this.setPropertyIfNotNull(props, "eclipse.product", this.productConfiguration.getId());
        this.setPropertyIfNotNull(props, "osgi.bundles.defaultStartLevel", "4");
        if (this.productConfiguration.getUseFeatures().booleanValue()) {
            this.setPropertyIfNotNull(props, "osgi.bundles", this.getFeaturesOsgiBundles());
        } else {
            this.setPropertyIfNotNull(props, "osgi.bundles", this.getPluginsOsgiBundles());
        }
        File configsFolder = new File(this.target, "configuration");
        configsFolder.mkdirs();
        File configIni = new File(configsFolder, "config.ini");
        try {
            FileOutputStream fos = new FileOutputStream(configIni);
            props.store(fos, "Product Runtime Configuration File");
            fos.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating .eclipseproduct file.", (Exception)e);
        }
    }

    private String getFeaturesOsgiBundles() {
        return "org.eclipse.equinox.common@2:start,org.eclipse.update.configurator@3:start,org.eclipse.core.runtime@start";
    }

    private String getPluginsOsgiBundles() {
        List plugins = this.productConfiguration.getPlugins();
        StringBuilder buf = new StringBuilder(plugins.size() * 10);
        for (PluginRef plugin : plugins) {
            if ("org.eclipse.osgi".equals(plugin.getId())) continue;
            if (buf.length() != 0) {
                buf.append(',');
            }
            buf.append(plugin.getId());
            if ("org.eclipse.core.runtime".equals(plugin.getId())) {
                buf.append("@start");
            }
            if (!this.isEclipse32Platform() || !"org.eclipse.equinox.common".equals(plugin.getId())) continue;
            buf.append("@2:start");
        }
        if (!this.isEclipse32Platform()) {
            if (buf.length() != 0) {
                buf.append(',');
            }
            String ws = this.state.getPlatformProperty("osgi.ws");
            String os = this.state.getPlatformProperty("osgi.os");
            String arch = this.state.getPlatformProperty("osgi.arch");
            buf.append("org.eclipse.equinox.launcher,");
            buf.append("org.eclipse.equinox.launcher." + ws + "." + os + "." + arch);
        }
        return buf.toString();
    }

    private void copyFeatures(List<Feature.FeatureRef> features) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("copying " + features.size() + " features "));
        for (Feature.FeatureRef feature : features) {
            this.copyFeature(feature);
        }
    }

    private void copyFeature(Feature.FeatureRef feature) throws MojoExecutionException {
        de.schlichtherle.io.File source;
        String featureVersion;
        String featureId = feature.getId();
        Feature featureRef = this.state.getFeature(featureId, featureVersion = feature.getVersion());
        if (featureRef == null) {
            throw new MojoExecutionException("Unable to resolve feature " + featureId + "_" + featureVersion);
        }
        MavenProject project = this.state.getMavenProject(featureRef);
        if (project == null) {
            FeatureDescription bundle = this.state.getFeatureDescription(featureId, featureVersion);
            if (bundle == null) {
                throw new MojoExecutionException("Unable to resolve feature " + featureId + "_" + featureVersion);
            }
            this.getLog().debug((CharSequence)("feature = bundle: " + bundle.getLocation()));
            source = new de.schlichtherle.io.File(bundle.getLocation());
        } else {
            this.getLog().debug((CharSequence)("feature = project: " + project.getArtifact()));
            source = new de.schlichtherle.io.File(project.getArtifact().getFile());
        }
        featureVersion = this.expandVerstion(featureRef.getVersion());
        File targetFolder = new File(this.featuresFolder, featureRef.getId() + "_" + featureVersion);
        targetFolder.mkdirs();
        source.copyAllTo(targetFolder);
        List featureRefs = featureRef.getIncludedFeatures();
        for (Feature.FeatureRef fRef : featureRefs) {
            this.copyFeature(fRef);
        }
        List pluginRefs = featureRef.getPlugins();
        for (PluginRef pluginRef : pluginRefs) {
            String bundleVersion;
            String pluginVersion;
            if (!this.matchCurrentPlataform(pluginRef) || (pluginVersion = pluginRef.getVersion()).equals(bundleVersion = this.copyPlugin(pluginRef.getId(), pluginVersion, pluginRef.isUnpack()))) continue;
            pluginRef.setVersion(bundleVersion);
        }
        featureRef.setVersion(featureVersion);
        try {
            Feature.write((Feature)featureRef, (File)new File(targetFolder, "feature.xml"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Fail to update feature.xml", (Exception)e);
        }
    }

    private String expandVerstion(String version) {
        if (this.qualifier != null && version.endsWith(".qualifier")) {
            version = version.substring(0, version.lastIndexOf(46) + 1);
            version = version + this.qualifier;
        }
        return version;
    }

    private boolean matchCurrentPlataform(PluginRef pluginRef) {
        String ws = this.state.getPlatformProperty("osgi.ws");
        String os = this.state.getPlatformProperty("osgi.os");
        String arch = this.state.getPlatformProperty("osgi.arch");
        String pluginWs = pluginRef.getWs();
        String pluginOs = pluginRef.getOs();
        String pluginArch = pluginRef.getArch();
        return !(pluginWs != null && !ws.equals(pluginWs) || pluginOs != null && !os.equals(pluginOs) || pluginArch != null && !arch.equals(pluginArch));
    }

    private void copyPlugins(Collection<PluginRef> plugins) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("copying " + plugins.size() + " plugins "));
        for (PluginRef plugin : plugins) {
            String bundleId = plugin.getId();
            String bundleVersion = plugin.getVersion();
            this.copyPlugin(bundleId, bundleVersion, plugin.isUnpack());
        }
        if (!this.isEclipse32Platform()) {
            String ws = this.state.getPlatformProperty("osgi.ws");
            String os = this.state.getPlatformProperty("osgi.os");
            String arch = this.state.getPlatformProperty("osgi.arch");
            this.copyPlugin("org.eclipse.equinox.launcher", null, false);
            this.copyPlugin("org.eclipse.equinox.launcher." + ws + "." + os + "." + arch, null, false);
        }
    }

    private String copyPlugin(String bundleId, String bundleVersion, boolean unpack) throws MojoExecutionException {
        Manifest manifest;
        BundleDescription bundle;
        this.getLog().debug((CharSequence)("Copying plugin " + bundleId + "_" + bundleVersion));
        if (bundleVersion == null || "0.0.0".equals(bundleVersion)) {
            bundleVersion = "highest version";
        }
        if ((bundle = this.state.getBundleDescription(bundleId, bundleVersion)) == null) {
            throw new MojoExecutionException("Plugin '" + bundleId + "_" + bundleVersion + "' not found!");
        }
        MavenProject bundleProject = this.state.getMavenProject(bundle);
        File source = bundleProject != null ? bundleProject.getArtifact().getFile() : new File(bundle.getLocation());
        de.schlichtherle.io.File manifestMf = new de.schlichtherle.io.File(source, "META-INF/MANIFEST.MF");
        try {
            manifest = new Manifest((InputStream)new FileInputStream((File)manifestMf));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read manifest file", (Exception)e);
        }
        bundleVersion = manifest.getMainAttributes().getValue("Bundle-Version");
        File target = new File(this.pluginsFolder, bundleId + "_" + bundleVersion + ".jar");
        if (source.isDirectory()) {
            this.copyToDirectory(source, this.pluginsFolder);
        } else if (unpack) {
            String path = target.getAbsolutePath();
            path = path.substring(0, path.length() - 4);
            target = new File(path);
            new de.schlichtherle.io.File(source).copyAllTo(target);
        } else {
            this.copyToFile(source, target);
        }
        return bundleVersion;
    }

    private void copyToFile(File source, File target) throws MojoExecutionException {
        try {
            target.getParentFile().mkdirs();
            if (source.isFile()) {
                FileUtils.copyFile((File)source, (File)target);
            } else if (source.isDirectory()) {
                FileUtils.copyDirectory((File)source, (File)target);
            } else {
                this.getLog().warn((CharSequence)("Skipping bundle " + source.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy " + source.getName(), (Exception)e);
        }
    }

    private void copyToDirectory(File source, File targetFolder) throws MojoExecutionException {
        try {
            if (source.isFile()) {
                FileUtils.copyFileToDirectory((File)source, (File)targetFolder);
            } else if (source.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)source, (File)targetFolder);
            } else {
                this.getLog().warn((CharSequence)("Skipping bundle " + source.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy " + source.getName(), (Exception)e);
        }
    }

    private void copyExecutable() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Creating launcher.exe");
        FeatureDescription feature = this.isEclipse32Platform() ? this.state.getFeatureDescription("org.eclipse.platform.launchers", null) : this.state.getFeatureDescription("org.eclipse.equinox.executable", null);
        if (feature == null) {
            throw new MojoExecutionException("RPC delta feature not found!");
        }
        File location = feature.getLocation();
        String ws = this.state.getPlatformProperty("osgi.ws");
        String os = this.state.getPlatformProperty("osgi.os");
        String arch = this.state.getPlatformProperty("osgi.arch");
        File osLauncher = new File(location, "bin/" + ws + "/" + os + "/" + arch);
        try {
            IOFileFilter eclipsecFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)"eclipsec"));
            FileUtils.copyDirectory((File)osLauncher, (File)this.target, (FileFilter)eclipsecFilter);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy launcher executable", (Exception)e);
        }
        File launcher = this.getLauncher();
        try {
            this.getLog().debug((CharSequence)"running chmod");
            ArchiveEntryUtils.chmod((File)launcher, (int)493, null);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Unable to make launcher being executable", (Exception)((Object)e));
        }
        if (this.productConfiguration.getLauncher() != null && this.productConfiguration.getLauncher().getName() != null) {
            String launcherName = this.productConfiguration.getLauncher().getName();
            this.getLog().debug((CharSequence)("Renaming launcher to " + launcherName));
            String newName = launcherName;
            if ("win32".equals(os)) {
                String extension = FilenameUtils.getExtension((String)launcher.getAbsolutePath());
                newName = launcherName + "." + extension;
            }
            launcher.renameTo(new File(launcher.getParentFile(), newName));
        }
        if (this.isEclipse32Platform()) {
            File startUpJar = new File(location, "bin/startup.jar");
            try {
                FileUtils.copyFileToDirectory((File)startUpJar, (File)this.target);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to copy startup.jar executable", (Exception)e);
            }
        }
    }

    private File getLauncher() throws MojoExecutionException {
        String os = this.state.getPlatformProperty("osgi.os");
        if ("win32".equals(os)) {
            return new File(this.target, "launcher.exe");
        }
        if ("linux".equals(os) || "solaris".equals(os) || "hpux".equals(os) || "aix".equals(os)) {
            return new File(this.target, "launcher");
        }
        if ("macosx".equals(os)) {
            return new File(this.target, "Eclipse.app/Contents/MacOS/launcher");
        }
        throw new MojoExecutionException("Unexpected OS: " + os);
    }

    private void setPropertyIfNotNull(Properties properties, String key, String value) {
        if (value != null) {
            properties.setProperty(key, value);
        }
    }

    public void contextualize(Context ctx) throws ContextException {
        this.plexus = (PlexusContainer)ctx.get((Object)"plexus");
    }
}

