/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.tycho.eclipsepackaging.Util;
import org.codehaus.tycho.eclipsepackaging.product.Plugin;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.osgitools.OsgiState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageFeatureMojo
extends AbstractMojo
implements Contextualizable {
    private OsgiState state;
    private PlexusContainer plexus;
    private static final String GENERATE_FEATURE = "generate.feature@";
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    protected MavenProject project;
    private File outputDirectory;
    private File basedir;
    private String finalName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(new File(this.basedir, "build.properties")));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading build properties", (Exception)e);
        }
        File outputJar = new File(this.outputDirectory, this.finalName + ".jar");
        outputJar.getParentFile().mkdirs();
        String[] binIncludes = props.getProperty("bin.includes").split(",");
        String[] files = Util.getIncludedFiles(this.basedir, binIncludes);
        MavenArchiver archiver = new MavenArchiver();
        JarArchiver jarArchiver = this.getJarArchiver();
        archiver.setArchiver(jarArchiver);
        archiver.setOutputFile(outputJar);
        jarArchiver.setDestFile(outputJar);
        try {
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i];
                File f = new File(this.basedir, fileName);
                if (f.isDirectory()) continue;
                jarArchiver.addFile(f, fileName);
            }
            archiver.createArchive(this.project, this.archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating feature package", e);
        }
        this.project.getArtifact().setFile(outputJar);
    }

    private void generateSources(Properties props) throws MojoExecutionException {
        boolean individualSourceBundle = Boolean.parseBoolean(props.getProperty("individualSourceBundles"));
        Set<Object> keys = props.keySet();
        for (Object keyObj : keys) {
            String key = keyObj.toString();
            if (!key.toString().startsWith(GENERATE_FEATURE)) continue;
            String baseFeature = props.getProperty(key);
            String sourceFeature = key.substring(GENERATE_FEATURE.length());
            if (individualSourceBundle) continue;
            this.generateSourceFeature(baseFeature, sourceFeature);
        }
    }

    private JarArchiver getJarArchiver() throws MojoExecutionException {
        try {
            JarArchiver jarArchiver = (JarArchiver)this.plexus.lookup(JarArchiver.ROLE, "jar");
            return jarArchiver;
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Unable to get JarArchiver", (Exception)((Object)e));
        }
    }

    private void generateSourceFeature(String baseFeatureId, String sourceFeature) throws MojoExecutionException {
        Feature baseFeature = this.state.getFeature(baseFeatureId, "highest version");
        if (baseFeature == null) {
            this.getLog().warn((CharSequence)("Base feature not found: " + baseFeatureId));
            return;
        }
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        plugins.add(new Plugin(sourceFeature, baseFeature.getVersion()));
        this.generateSourceFeature(sourceFeature, baseFeature.getVersion(), plugins);
    }

    private void generateSourceFeature(String featureId, String featureVersion, List<Plugin> plugins) throws MojoExecutionException {
        File target = new File(this.outputDirectory, featureId);
        target.mkdirs();
        File featureFile = new File(target, "feature.xml");
        try {
            FileWriter fw = new FileWriter(featureFile);
            fw.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append('\n');
            fw.append("<feature id=\"" + featureId + "\" version=\"" + featureVersion + "\" primary=\"false\" >").append('\n');
            for (Plugin plugin : plugins) {
                fw.append("\t<plugin id=\"" + plugin.getId() + "\" version=\"" + plugin.getVersion() + "\" />").append('\n');
            }
            fw.append("</feature>").append('\n');
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating feature.xml for " + featureId + "_" + featureVersion, (Exception)e);
        }
        File outputJar = new File(this.outputDirectory, featureId + "-" + featureVersion + ".jar");
        JarArchiver jarArchiver = this.getJarArchiver();
        jarArchiver.setDestFile(outputJar);
        try {
            jarArchiver.addFile(featureFile, "feature.xml");
            jarArchiver.createArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error packing source feature " + featureId + "_" + featureVersion, e);
        }
    }

    public void contextualize(Context ctx) throws ContextException {
        this.plexus = (PlexusContainer)ctx.get((Object)"plexus");
    }
}

