/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging.product;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Field;
import java.util.Iterator;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.tycho.eclipsepackaging.product.ProductConfiguration;

public class ProductConfigurationConverter
implements Converter {
    private Log log;

    public ProductConfigurationConverter(Log log) {
        this();
        this.log = log;
    }

    public ProductConfigurationConverter() {
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        context.convertAnother(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object value;
        Field field;
        String name;
        ProductConfiguration cfg = new ProductConfiguration();
        Field[] fields = ProductConfiguration.class.getDeclaredFields();
        Iterator attributeNames = reader.getAttributeNames();
        while (attributeNames.hasNext()) {
            name = (String)attributeNames.next();
            field = this.getField(name, fields);
            if (field == null) continue;
            value = reader.getAttribute(name);
            try {
                BeanUtils.setProperty((Object)cfg, (String)name, (Object)value);
            }
            catch (Exception e) {
                throw new ConversionException((Throwable)e);
            }
        }
        while (reader.hasMoreChildren()) {
            try {
                reader.moveDown();
                name = reader.getNodeName();
                field = this.getField(name, fields);
                if (field == null) continue;
                value = context.convertAnother((Object)name, field.getType());
                try {
                    field.set(cfg, value);
                }
                catch (Exception e) {
                    throw new ConversionException((Throwable)e);
                }
            }
            finally {
                reader.moveUp();
            }
        }
        return cfg;
    }

    private Field getField(String name, Field[] fields) {
        Field field = null;
        for (Field f : fields) {
            if (!f.getName().equals(name)) continue;
            field = f;
            break;
        }
        if (field == null) {
            if (this.log != null) {
                this.log.warn((CharSequence)("Tycho doesn't handle '" + name + "' property."));
            }
            return null;
        }
        field.setAccessible(true);
        return field;
    }

    public boolean canConvert(Class type) {
        return type == ProductConfiguration.class;
    }
}

