/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.jar.JarSignMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.gzip.GZipCompressor;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.pack200.Pack200Archiver;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.tycho.eclipsepackaging.Util;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.model.IFeatureRef;
import org.codehaus.tycho.model.UpdateSite;
import org.codehaus.tycho.osgitools.OsgiState;
import org.eclipse.osgi.service.resolver.BundleDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSiteMojo
extends AbstractMojo
implements Contextualizable {
    private static final int KBYTE = 1024;
    private OsgiState state;
    private File target;
    private File temp;
    private File features;
    private File basedir;
    private PlexusContainer plexus;
    private boolean inlineArchives;
    protected String qualifier;
    protected MavenProject project;
    private boolean sign;
    private File keystore;
    private String storepass;
    private String alias;
    private String keypass;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.target.mkdirs();
        try {
            UpdateSite site = UpdateSite.read((File)new File(this.basedir, "site.xml"));
            Map archives = site.getArchives();
            for (UpdateSite.FeatureRef feature : site.getFeatures()) {
                this.packageFeature((IFeatureRef)feature, archives, site.isPack200());
            }
            if (this.inlineArchives) {
                site.removeArchives();
            }
            File file = new File(this.target, "site.xml");
            UpdateSite.write((UpdateSite)site, (File)file);
            this.project.getArtifact().setFile(file);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void packageFeature(IFeatureRef featureRef, Map<String, String> archives, boolean isPack200) throws Exception {
        MavenProject featureProject;
        Feature feature = this.state.getFeature(featureRef.getId(), featureRef.getVersion());
        if (feature == null) {
            String groupId = featureRef.getId().substring(0, featureRef.getId().lastIndexOf(46));
            throw new ArtifactResolutionException("Feature " + featureRef.getId() + " not found", groupId, featureRef.getId(), featureRef.getVersion(), "eclipse-feature", null, null);
        }
        String artifactId = feature.getId();
        String version = this.expandVerstion(feature.getVersion());
        String url = "features/" + artifactId + "_" + version + ".jar";
        File outputJar = new File(this.target, url);
        if (!outputJar.canRead() && (featureProject = this.state.getMavenProject(feature)) != null) {
            feature = new Feature(feature);
            for (Feature.PluginRef plugin : feature.getPlugins()) {
                this.packagePlugin(plugin, archives, isPack200);
            }
            for (Feature.FeatureRef includedRef : feature.getIncludedFeatures()) {
                this.packageFeature((IFeatureRef)includedRef, archives, isPack200);
            }
            feature.setVersion(version);
            this.features.mkdirs();
            File featureFile = new File(this.features, artifactId + "-feature.xml");
            Feature.write((Feature)feature, (File)featureFile);
            outputJar.getParentFile().mkdirs();
            Properties props = new Properties();
            props.load(new FileInputStream(new File(featureProject.getBasedir(), "build.properties")));
            String[] binIncludes = props.getProperty("bin.includes").split(",");
            String[] files = Util.getIncludedFiles(featureProject.getBasedir(), binIncludes);
            JarArchiver jarArchiver = (JarArchiver)this.plexus.lookup(JarArchiver.ROLE, "jar");
            jarArchiver.setDestFile(outputJar);
            for (int i = 0; i < files.length; ++i) {
                File f;
                String fileName = files[i];
                File file = f = "feature.xml".equals(fileName) ? featureFile : new File(featureProject.getBasedir(), fileName);
                if (f.isDirectory()) continue;
                jarArchiver.addFile(f, fileName);
            }
            jarArchiver.createArchive();
            if (this.sign) {
                this.signJar(outputJar);
            }
            if (isPack200) {
                this.shipPack200(outputJar, url);
            }
        }
        if (featureRef instanceof UpdateSite.FeatureRef) {
            ((UpdateSite.FeatureRef)featureRef).setUrl(url);
        }
        featureRef.setVersion(version);
    }

    private String expandVerstion(String version) {
        if (this.qualifier != null && version.endsWith(".qualifier")) {
            version = version.substring(0, version.lastIndexOf(46) + 1);
            version = version + this.qualifier;
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packagePlugin(Feature.PluginRef plugin, Map<String, String> archives, boolean isPack200) throws Exception {
        Manifest mf;
        File file;
        BundleDescription bundle;
        String bundleId = plugin.getId();
        String version = plugin.getVersion();
        String path = "plugins/" + bundleId + "_" + version + ".jar";
        if (archives.containsKey(path)) {
            if (this.inlineArchives) {
                URL url = new URL(archives.get(path));
                InputStream is = url.openStream();
                try {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(this.target, path)));
                    try {
                        IOUtil.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                }
                finally {
                    is.close();
                }
            }
            return;
        }
        if ("0.0.0".equals(version)) {
            version = "highest version";
        }
        if ((bundle = this.state.getBundleDescription(bundleId, version)) == null) {
            throw new MojoExecutionException("Can't find bundle " + bundleId);
        }
        MavenProject bundleProject = this.state.getMavenProject(bundle);
        if (bundleProject != null) {
            file = bundleProject.getArtifact().getFile();
        } else {
            file = new File(bundle.getLocation());
            if (file.isDirectory()) {
                throw new MojoExecutionException("Directory based bundle " + bundleId);
            }
        }
        JarFile jar = new JarFile(file);
        long installSize = 0L;
        try {
            mf = jar.getManifest();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                long entrySize = entry.getSize();
                if (entrySize <= 0L) continue;
                installSize += entrySize;
            }
        }
        finally {
            jar.close();
        }
        String bundleVersion = mf.getMainAttributes().getValue("Bundle-Version");
        plugin.setVersion(bundleVersion);
        String url = "plugins/" + bundleId + "_" + bundleVersion + ".jar";
        File outputJar = new File(this.target, url);
        outputJar.getParentFile().mkdirs();
        FileUtils.copyFile((File)file, (File)outputJar);
        if (this.sign) {
            this.signJar(outputJar);
        }
        if (isPack200) {
            this.shipPack200(outputJar, url);
        }
        plugin.setDownloadSide(outputJar.length() / 1024L);
        plugin.setInstallSize(installSize / 1024L);
    }

    private void shipPack200(File jar, String url) throws ArchiverException, IOException, ComponentLookupException {
        File outputPack = new File(this.temp, url + ".pack");
        Pack200Archiver packArchiver = new Pack200Archiver();
        packArchiver.setSourceJar(jar);
        packArchiver.setDestFile(outputPack);
        packArchiver.createArchive();
        GZipCompressor gzCompressor = new GZipCompressor();
        gzCompressor.setDestFile(new File(this.target, url + ".pack.gz"));
        gzCompressor.setSourceFile(outputPack);
        gzCompressor.execute();
    }

    private void signJar(File outputJar) throws MojoExecutionException {
        if (this.keystore == null) {
            this.keystore = new File(System.getProperty("user.home"), ".keystore");
        }
        if (!this.keystore.exists()) {
            this.getLog().warn((CharSequence)("Unable to sign, keystore file not found: " + this.keystore.getAbsolutePath()));
            return;
        }
        if (this.storepass == null) {
            this.getLog().warn((CharSequence)"Unable to sign, keystore password must be specifyed.");
            return;
        }
        if (this.alias == null) {
            this.getLog().warn((CharSequence)"Unable to sign, alias must be specifyed.");
            return;
        }
        if (this.keypass == null) {
            this.getLog().warn((CharSequence)"Unable to sign, keypass must be specifyed.");
            return;
        }
        JarSignMojo sign = new JarSignMojo();
        sign.setKeystore(this.keystore.getAbsolutePath());
        sign.setStorepass(this.storepass);
        sign.setAlias(this.alias);
        sign.setKeypass(this.keypass);
        sign.setJarPath(outputJar);
        sign.setBasedir(this.basedir);
        sign.setWorkingDir(this.basedir);
        sign.setLog(this.getLog());
        sign.setVerbose(false);
        sign.setVerify(false);
        sign.execute();
    }

    public void contextualize(Context ctx) throws ContextException {
        this.plexus = (PlexusContainer)ctx.get((Object)"plexus");
    }
}

