/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.ArrayUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.tycho.eclipsepackaging.Util;
import org.codehaus.tycho.osgitools.BundleFile;
import org.codehaus.tycho.osgitools.OsgiState;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CopyFeatureFilesMojo
extends AbstractMojo {
    protected MavenProject project;
    private File deployDirectory;
    private boolean generateFeatureXML;
    private File featureXML;
    private boolean failOnError;
    private File outputDir;
    private OsgiState state;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File destination;
        if (!this.generateFeatureXML) {
            this.validate();
        }
        if (!(destination = new File(this.deployDirectory, "plugins")).exists()) {
            destination.mkdirs();
        }
        this.createFeatureDir();
        this.copyRootFiles();
        ArrayList<BundleFile> files = new ArrayList<BundleFile>();
        for (Artifact a : this.project.getDependencyArtifacts()) {
            if (!DefaultArtifact.SCOPE_COMPILE.equals(a.getScope())) continue;
            try {
                File bundleLocation = a.getFile();
                BundleFile b = new BundleFile(this.state.loadManifest(bundleLocation), bundleLocation);
                String bundleFileName = b.getSymbolicName() + "_" + b.getVersion() + ".jar";
                files.add(b);
                FileUtils.copyFile((File)bundleLocation, (File)new File(destination, bundleFileName));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying " + a.getFile() + " to " + destination, (Exception)e);
            }
        }
        if (this.generateFeatureXML) {
            try {
                VelocityEngine ve = new VelocityEngine();
                ve.setProperty("resource.loader", (Object)"class");
                ve.setProperty("class.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
                ve.init();
                VelocityContext context = new VelocityContext();
                context.put("project", (Object)this.project);
                context.put("bundles", files);
                File featureDir = new File(this.deployDirectory, "features/" + this.project.getArtifactId() + "_" + this.project.getVersion());
                File output = new File(featureDir, "feature.xml");
                FileWriter w = new FileWriter(output);
                Template t = ve.getTemplate("/feature.xml.vm");
                t.merge((Context)context, (Writer)w);
                w.close();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error while creating feature.xml", e);
            }
        }
    }

    private void createFeatureDir() throws MojoExecutionException {
        try {
            File featureDir = new File(this.deployDirectory, "features/" + this.project.getArtifactId() + "_" + this.project.getVersion());
            Properties props = new Properties();
            props.load(new FileInputStream(new File(this.project.getBasedir(), "build.properties")));
            String[] binIncludes = props.getProperty("bin.includes").split(",");
            String[] files = Util.getIncludedFiles(this.project.getBasedir(), binIncludes);
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i];
                File f = new File(this.project.getBasedir(), fileName);
                File target = new File(featureDir, fileName);
                if (f.isDirectory()) {
                    target.mkdirs();
                    continue;
                }
                FileUtils.copyFile((File)f, (File)target);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }

    private void copyRootFiles() throws MojoExecutionException {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(new File(this.project.getBasedir(), "build.properties")));
        }
        catch (FileNotFoundException e1) {
            throw new MojoExecutionException("Could not find build.properties");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not read build.properties", (Exception)e);
        }
        String root = props.getProperty("root");
        if (root != null) {
            String[] includes = root.split(",");
            for (int i = 0; i < includes.length; ++i) {
                String include = includes[i];
                String[] files = Util.getIncludedFiles(this.project.getBasedir(), new String[]{include});
                for (int j = 0; j < files.length; ++j) {
                    String file = files[j];
                    File f = new File(this.project.getBasedir(), file);
                    if (include.endsWith("/")) {
                        file = file.substring(include.length());
                    }
                    try {
                        FileUtils.copyFile((File)f, (File)new File(this.deployDirectory, file));
                        continue;
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error copying file " + f);
                    }
                }
            }
        }
    }

    private String[] getFeaturePluginIDs() throws MojoExecutionException {
        String xpath = "/feature//plugin/@id";
        try {
            XPath path = XPathFactory.newInstance().newXPath();
            FileInputStream fis = new FileInputStream(this.featureXML);
            InputSource is = new InputSource(fis);
            NodeList list = (NodeList)path.evaluate(xpath, is, XPathConstants.NODESET);
            String[] result = new String[list.getLength()];
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                result[i] = node.getTextContent();
            }
            return result;
        }
        catch (XPathExpressionException e) {
            throw new MojoExecutionException("XPath error: " + xpath, (Exception)e);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("File not found: " + this.featureXML, (Exception)e);
        }
    }

    private void validate() throws MojoFailureException, MojoExecutionException {
        Set pomPlugins = this.project.getDependencyArtifacts();
        Object[] featurePlugins = this.getFeaturePluginIDs();
        boolean fail = false;
        for (Artifact a : pomPlugins) {
            String id = a.getArtifactId();
            if (ArrayUtils.contains((Object[])featurePlugins, (Object)id)) continue;
            this.getLog().error((CharSequence)("Plugin found in POM but not in feature: " + id));
            fail = true;
        }
        for (int i = 0; i < featurePlugins.length; ++i) {
            String id = featurePlugins[i];
            boolean found = false;
            for (Artifact a : pomPlugins) {
                if (!id.equals(a.getArtifactId())) continue;
                found = true;
            }
            if (found) continue;
            fail = true;
            this.getLog().error((CharSequence)("Plugin found in feature but not in POM: " + id));
        }
        if (this.failOnError && fail) {
            throw new MojoFailureException("validation failed");
        }
    }
}

