/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgicompiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.tycho.osgicompiler.ClasspathComputer;
import org.codehaus.tycho.osgicompiler.copied.AbstractCompilerMojo;
import org.codehaus.tycho.osgicompiler.copied.CompilationFailureException;
import org.codehaus.tycho.osgitools.DependencyComputer;
import org.codehaus.tycho.osgitools.OsgiState;
import org.codehaus.tycho.osgitools.project.BuildOutputJar;
import org.codehaus.tycho.osgitools.project.EclipsePluginProject;
import org.codehaus.tycho.utils.ArtifactRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOsgiCompilerMojo
extends AbstractCompilerMojo {
    private File storage;
    private MavenProject project;
    private EclipsePluginProject pdeProject;
    private boolean usePdeSourceRoots;
    private ArtifactRef[] extraClasspathElements;
    private OsgiState state;
    private DependencyComputer dependencyComputer;
    private MavenSession session;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private MavenProjectBuilder mavenProjectBuilder;
    private File buildTarget;
    private ClasspathComputer classpathComputer;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private BuildOutputJar outputJar;

    @Override
    public void execute() throws MojoExecutionException, CompilationFailureException {
        this.pdeProject = this.state.getEclipsePluginProject(this.project);
        if (this.usePdeSourceRoots) {
            this.getLog().info((CharSequence)"Using compile source roots from build.properties");
        }
        Iterator i$ = this.pdeProject.getOutputJars().iterator();
        while (i$.hasNext()) {
            BuildOutputJar jar;
            this.outputJar = jar = (BuildOutputJar)i$.next();
            this.outputJar.getOutputDirectory().mkdirs();
            super.execute();
            this.getClasspathComputer().addOutputDirectory(this.outputJar.getOutputDirectory());
        }
        BuildOutputJar dotOutputJar = this.pdeProject.getDotOutputJar();
        if (dotOutputJar != null) {
            this.project.getArtifact().setFile(dotOutputJar.getOutputDirectory());
        }
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputJar.getOutputDirectory();
    }

    @Override
    public List<String> getClasspathElements() throws MojoExecutionException {
        List<String> classpath = this.getClasspathComputer().computeClasspath();
        if (this.extraClasspathElements != null) {
            ArtifactRepository localRepository = this.session.getLocalRepository();
            List remoteRepositories = this.project.getRemoteArtifactRepositories();
            for (ArtifactRef a : this.extraClasspathElements) {
                try {
                    Artifact artifact = this.artifactFactory.createArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), "compile", "jar");
                    this.resolver.resolve(artifact, remoteRepositories, localRepository);
                    classpath.add(artifact.getFile().getAbsolutePath() + "[+**/*]");
                    Artifact pomArtifact = this.artifactFactory.createArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), "pom", "pom");
                    this.resolver.resolve(pomArtifact, remoteRepositories, localRepository);
                    FileUtils.copyFileToDirectory((File)pomArtifact.getFile(), (File)this.buildTarget);
                    DefaultProjectBuilderConfiguration pbc = new DefaultProjectBuilderConfiguration();
                    pbc.setLocalRepository(localRepository);
                    MavenProject pomProject = this.mavenProjectBuilder.buildProjectWithDependencies(new File(this.buildTarget, pomArtifact.getFile().getName()), (ProjectBuilderConfiguration)pbc).getProject();
                    for (Artifact b : pomProject.getArtifacts()) {
                        classpath.add(b.getFile().getAbsolutePath() + "[+**/*]");
                    }
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Could not resolve extra classpath entry", e);
                }
            }
        }
        return classpath;
    }

    private ClasspathComputer getClasspathComputer() {
        if (this.classpathComputer == null) {
            this.classpathComputer = new ClasspathComputer(this.state, this.dependencyComputer, this.project, this.storage);
        }
        return this.classpathComputer;
    }

    @Override
    protected final List<String> getCompileSourceRoots() throws MojoExecutionException {
        return this.usePdeSourceRoots ? this.getPdeCompileSourceRoots() : this.getConfiguredCompileSourceRoots();
    }

    protected abstract List<String> getConfiguredCompileSourceRoots();

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        StaleSourceScanner scanner = null;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (this.includes.isEmpty()) {
                this.includes.add("**/*.java");
            }
            scanner = new StaleSourceScanner((long)staleMillis, this.includes, this.excludes);
        }
        return scanner;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        SimpleSourceInclusionScanner scanner = null;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            this.includes = Collections.singleton("**/*." + inputFileEnding);
            scanner = new SimpleSourceInclusionScanner(this.includes, Collections.EMPTY_SET);
        } else {
            if (this.includes.isEmpty()) {
                this.includes.add("**/*." + inputFileEnding);
            }
            scanner = new SimpleSourceInclusionScanner(this.includes, this.excludes);
        }
        return scanner;
    }

    protected List<String> getPdeCompileSourceRoots() throws MojoExecutionException {
        ArrayList<String> roots = new ArrayList<String>();
        for (File folder : this.outputJar.getSourceFolders()) {
            try {
                roots.add(folder.getCanonicalPath());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unexpected IOException", (Exception)e);
            }
        }
        return roots;
    }

    @Override
    protected CompilerConfiguration getCompilerConfiguration(List<String> compileSourceRoots) throws MojoExecutionException {
        Properties props;
        String encoding;
        CompilerConfiguration compilerConfiguration = super.getCompilerConfiguration(compileSourceRoots);
        if (this.usePdeSourceRoots && (encoding = (props = this.pdeProject.getBuildProperties()).getProperty("javacDefaultEncoding." + this.outputJar)) != null) {
            compilerConfiguration.setSourceEncoding(encoding);
        }
        return compilerConfiguration;
    }
}

