/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle;

import java.io.DataInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Lexer {
    final int BEGIN = 0;
    final int END = 1;
    DataInputStream in;
    String[][] token;
    Pattern[][] patterns;
    int tokenCount;
    String line;

    public Lexer(byte[] bytes, String[][] token) {
        this.line = new String(bytes);
        this.patterns = new Pattern[token.length][2];
        for (int i = 0; i < token.length; ++i) {
            this.patterns[i][0] = Pattern.compile(token[i][0]);
            this.patterns[i][1] = Pattern.compile(token[i][1]);
        }
    }

    public Lexer(byte[] bytes, Pattern[][] patterns) {
        this.line = new String(bytes);
        this.patterns = patterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextToken() throws Exception {
        if (this.tokenCount >= this.patterns.length) {
            this.tokenCount = 0;
        }
        boolean pos = false;
        Matcher matcher = null;
        if (this.line != null && (matcher = this.patterns[this.tokenCount][0].matcher(this.line)).find()) {
            this.line = this.line.substring(matcher.end());
            matcher = this.patterns[this.tokenCount][1].matcher(this.line);
            if (matcher.find()) {
                try {
                    String string = this.line.substring(0, matcher.start()).trim();
                    Object var5_4 = null;
                    ++this.tokenCount;
                    this.line = this.line.substring(matcher.end());
                    return string;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    ++this.tokenCount;
                    this.line = this.line.substring(matcher.end());
                    throw throwable;
                }
            }
            return null;
        }
        return null;
    }

    public String find(String patternStr, CharSequence input) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }
}

