/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.unmarshallers;

import org.sonar.wsclient.services.Profile;
import org.sonar.wsclient.services.WSUtils;
import org.sonar.wsclient.unmarshallers.AbstractUnmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileUnmarshaller
extends AbstractUnmarshaller<Profile> {
    @Override
    protected Profile parse(Object json) {
        WSUtils utils = WSUtils.getINSTANCE();
        Profile profile = new Profile();
        profile.setLanguage(utils.getString(json, "language")).setName(utils.getString(json, "name")).setDefaultProfile(utils.getBoolean(json, "default")).setParentName(utils.getString(json, "parent"));
        this.parseRules(utils, profile, json);
        return profile;
    }

    private void parseRules(WSUtils utils, Profile profile, Object json) {
        Object rulesJson = utils.getField(json, "rules");
        if (rulesJson != null) {
            for (int i = 0; i < utils.getArraySize(rulesJson); ++i) {
                Object ruleJson = utils.getArrayElement(rulesJson, i);
                if (ruleJson == null) continue;
                Profile.Rule rule = new Profile.Rule();
                rule.setKey(utils.getString(ruleJson, "key"));
                rule.setRepository(utils.getString(ruleJson, "repo"));
                rule.setSeverity(utils.getString(ruleJson, "severity"));
                rule.setInheritance(utils.getString(ruleJson, "inheritance"));
                this.parseRuleParameters(utils, rule, ruleJson);
                profile.addRule(rule);
            }
        }
    }

    private void parseRuleParameters(WSUtils utils, Profile.Rule rule, Object ruleJson) {
        Object paramsJson = utils.getField(ruleJson, "params");
        if (paramsJson != null) {
            for (int indexParam = 0; indexParam < utils.getArraySize(paramsJson); ++indexParam) {
                Object paramJson = utils.getArrayElement(paramsJson, indexParam);
                rule.addParameter(utils.getString(paramJson, "key"), utils.getString(paramJson, "value"));
            }
        }
    }
}

