/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import java.util.Date;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.TimeMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeMachineQuery
extends Query<TimeMachine> {
    public static final String BASE_URL = "/api/timemachine";
    private String resourceKeyOrId;
    private String[] metrics;
    private Date from;
    private Date to;
    private String model;
    private String[] characteristicKeys;

    public TimeMachineQuery(String resourceKeyOrId) {
        this.resourceKeyOrId = resourceKeyOrId;
    }

    public String[] getMetrics() {
        return this.metrics;
    }

    public TimeMachineQuery setMetrics(String ... metrics) {
        this.metrics = metrics;
        return this;
    }

    public Date getFrom() {
        return this.from;
    }

    public TimeMachineQuery setFrom(Date from) {
        this.from = from;
        return this;
    }

    public Date getTo() {
        return this.to;
    }

    public TimeMachineQuery setTo(Date to) {
        this.to = to;
        return this;
    }

    public TimeMachineQuery setCharacteristicKeys(String model, String ... keys) {
        this.model = model;
        this.characteristicKeys = keys;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder(BASE_URL);
        url.append('?');
        TimeMachineQuery.appendUrlParameter(url, "resource", this.resourceKeyOrId);
        TimeMachineQuery.appendUrlParameter(url, "metrics", this.metrics);
        TimeMachineQuery.appendUrlParameter(url, "fromDateTime", this.from, true);
        TimeMachineQuery.appendUrlParameter(url, "toDateTime", this.to, true);
        TimeMachineQuery.appendUrlParameter(url, "model", this.model);
        TimeMachineQuery.appendUrlParameter(url, "characteristics", this.characteristicKeys);
        return url.toString();
    }

    @Override
    public Class<TimeMachine> getModelClass() {
        return TimeMachine.class;
    }

    public static TimeMachineQuery createForMetrics(String resourceKeyOrId, String ... metricKeys) {
        return new TimeMachineQuery(resourceKeyOrId).setMetrics(metricKeys);
    }

    public static TimeMachineQuery createForMetrics(Resource resource, String ... metricKeys) {
        return new TimeMachineQuery(resource.getId().toString()).setMetrics(metricKeys);
    }
}

