/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.Review;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewQuery
extends Query<Review> {
    public static final String BASE_URL = "/api/reviews";
    public static final String OUTPUT_PLAIN = "PLAIN";
    public static final String OUTPUT_HTML = "HTML";
    @Deprecated
    private String reviewType;
    private Long id;
    private Long[] ids;
    private String[] statuses;
    private String[] severities;
    private String[] projectKeysOrIds;
    private String[] resourceKeysOrIds;
    private String[] authorLogins;
    private String[] assigneeLogins;
    private String output;
    private String[] resolutions;

    @Deprecated
    public String getReviewType() {
        return this.reviewType;
    }

    @Deprecated
    public ReviewQuery setReviewType(String reviewType) {
        this.reviewType = reviewType;
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public ReviewQuery setId(Long id) {
        this.id = id;
        return this;
    }

    public Long[] getIds() {
        return this.ids;
    }

    public ReviewQuery setIds(Long ... ids) {
        this.ids = ids;
        return this;
    }

    public String[] getStatuses() {
        return this.statuses;
    }

    public ReviewQuery setStatuses(String ... statuses) {
        this.statuses = statuses;
        return this;
    }

    public String[] getSeverities() {
        return this.severities;
    }

    public ReviewQuery setSeverities(String ... severities) {
        this.severities = severities;
        return this;
    }

    public String[] getProjectKeysOrIds() {
        return this.projectKeysOrIds;
    }

    public ReviewQuery setProjectKeysOrIds(String ... projectKeysOrIds) {
        this.projectKeysOrIds = projectKeysOrIds;
        return this;
    }

    public String[] getResourceKeysOrIds() {
        return this.resourceKeysOrIds;
    }

    public ReviewQuery setResourceKeysOrIds(String ... resourceKeysOrIds) {
        this.resourceKeysOrIds = resourceKeysOrIds;
        return this;
    }

    @Deprecated
    public String[] getAuthorLoginsOrIds() {
        return this.authorLogins;
    }

    @Deprecated
    public ReviewQuery setAuthorLoginsOrIds(String ... authorLoginsOrIds) {
        this.setAuthorLogins(authorLoginsOrIds);
        return this;
    }

    public String[] getAuthorLogins() {
        return this.authorLogins;
    }

    public ReviewQuery setAuthorLogins(String ... authorLogins) {
        this.authorLogins = authorLogins;
        return this;
    }

    @Deprecated
    public String[] getAssigneeLoginsOrIds() {
        return this.assigneeLogins;
    }

    @Deprecated
    public ReviewQuery setAssigneeLoginsOrIds(String ... assigneeLoginsOrIds) {
        this.setAssigneeLogins(assigneeLoginsOrIds);
        return this;
    }

    public String[] getAssigneeLogins() {
        return this.assigneeLogins;
    }

    public ReviewQuery setAssigneeLogins(String ... assigneeLogins) {
        this.assigneeLogins = assigneeLogins;
        return this;
    }

    public String getOutput() {
        return this.output;
    }

    public ReviewQuery setOutput(String output) {
        this.output = output;
        return this;
    }

    public String[] getResolutions() {
        return this.resolutions;
    }

    public ReviewQuery setResolutions(String ... resolutions) {
        this.resolutions = resolutions;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder(BASE_URL);
        url.append('?');
        if (this.id != null) {
            ReviewQuery.appendUrlParameter(url, "ids", this.id);
        } else if (this.ids != null) {
            ReviewQuery.appendUrlParameter(url, "ids", this.ids);
        }
        ReviewQuery.appendUrlParameter(url, "statuses", this.statuses);
        ReviewQuery.appendUrlParameter(url, "severities", this.severities);
        ReviewQuery.appendUrlParameter(url, "projects", this.projectKeysOrIds);
        ReviewQuery.appendUrlParameter(url, "resources", this.resourceKeysOrIds);
        ReviewQuery.appendUrlParameter(url, "authors", this.authorLogins);
        ReviewQuery.appendUrlParameter(url, "assignees", this.assigneeLogins);
        ReviewQuery.appendUrlParameter(url, "output", this.output);
        ReviewQuery.appendUrlParameter(url, "resolutions", this.resolutions);
        if (this.resolutions == null && this.reviewType != null) {
            ReviewQuery.appendUrlParameter(url, "review_type", this.reviewType);
        }
        return url.toString();
    }

    @Override
    public Class<Review> getModelClass() {
        return Review.class;
    }

    public static ReviewQuery createForReview(Long id) {
        return new ReviewQuery().setId(id);
    }

    public static ReviewQuery createForResource(Resource resource) {
        return new ReviewQuery().setResourceKeysOrIds(resource.getId().toString());
    }
}

