/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.wsclient.services.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profile
extends Model {
    private String language;
    private String name;
    private boolean defaultProfile;
    private String parentName;
    private List<Rule> rules = new ArrayList<Rule>();

    public String getLanguage() {
        return this.language;
    }

    public Profile setLanguage(String s) {
        this.language = s;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Profile setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isDefaultProfile() {
        return this.defaultProfile;
    }

    public Profile setDefaultProfile(boolean b) {
        this.defaultProfile = b;
        return this;
    }

    public String getParentName() {
        return this.parentName;
    }

    public Profile setParentName(String s) {
        this.parentName = s;
        return this;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public Rule getRule(String repositoryKey, String ruleKey) {
        for (Rule rule : this.rules) {
            if (!repositoryKey.equals(rule.getRepository()) || !ruleKey.equals(rule.getKey())) continue;
            return rule;
        }
        return null;
    }

    public Profile addRule(Rule rule) {
        this.rules.add(rule);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Rule {
        private String key;
        private String repository;
        private String severity;
        private String inheritance;
        private Map<String, String> parameters;

        public String getKey() {
            return this.key;
        }

        public Rule setKey(String key) {
            this.key = key;
            return this;
        }

        public String getRepository() {
            return this.repository;
        }

        public Rule setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public String getSeverity() {
            return this.severity;
        }

        public Rule setSeverity(String severity) {
            this.severity = severity;
            return this;
        }

        public String getInheritance() {
            return this.inheritance;
        }

        public Rule setInheritance(String inheritance) {
            this.inheritance = inheritance;
            return this;
        }

        public Map<String, String> getParameters() {
            if (this.parameters == null) {
                return Collections.emptyMap();
            }
            return this.parameters;
        }

        public String getParameter(String key) {
            return this.getParameters().get(key);
        }

        public Rule addParameter(String key, String value) {
            if (this.parameters == null) {
                this.parameters = new HashMap<String, String>();
            }
            this.parameters.put(key, value);
            return this;
        }
    }
}

