/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import org.apache.commons.lang.StringUtils;
import org.jacoco.core.runtime.AgentOptions;
import org.sonar.api.BatchExtension;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.config.Settings;
import org.sonar.plugins.jacoco.JaCoCoAgentDownloader;

@Properties(value={@Property(key="sonar.jacoco.reportPath", name="File with execution data", defaultValue="target/jacoco.exec", description="Path (absolute or relative) to the file with execution data.", global=false, module=true, project=true), @Property(key="sonar.jacoco.includes", name="Includes", description="A list of class names that should be included in execution analysis. The list entries are separated by a colon (:) and may use wildcard characters (* and ?). Except for performance optimization or technical corner cases this option is normally not required.", global=true, project=true, module=true), @Property(key="sonar.jacoco.excludes", name="Excludes", defaultValue="*_javassist_*", description="A list of class names that should be excluded from execution analysis. The list entries are separated by a colon (:) and may use wildcard characters (* and ?). Except for performance optimization or technical corner cases this option is normally not required.", global=true, project=true, module=true), @Property(key="sonar.jacoco.exclclassloader", name="Excluded class loaders", description="A list of class loader names that should be excluded from execution analysis. The list entries are separated by a colon (:) and may use wildcard characters (* and ?). This option might be required in case of special frameworks that conflict with JaCoCo code instrumentation, in particular class loaders that do not have access to the Java runtime classes.", global=true, project=true, module=true), @Property(key="sonar.jacoco.itReportPath", name="File with execution data for integration tests", defaultValue="", description="Path (absolute or relative) to the file with execution data.", global=false, module=true, project=true), @Property(key="sonar.jacoco.antTargets", name="Ant targets", defaultValue="", description="Comma separated list of Ant targets for execution of tests.", global=true, module=true, project=true)})
public class JacocoConfiguration
implements BatchExtension {
    public static final String REPORT_PATH_PROPERTY = "sonar.jacoco.reportPath";
    public static final String REPORT_PATH_DEFAULT_VALUE = "target/jacoco.exec";
    public static final String IT_REPORT_PATH_PROPERTY = "sonar.jacoco.itReportPath";
    public static final String IT_REPORT_PATH_DEFAULT_VALUE = "";
    public static final String INCLUDES_PROPERTY = "sonar.jacoco.includes";
    public static final String EXCLUDES_PROPERTY = "sonar.jacoco.excludes";
    public static final String EXCLUDES_DEFAULT_VALUE = "*_javassist_*";
    public static final String EXCLCLASSLOADER_PROPERTY = "sonar.jacoco.exclclassloader";
    public static final String ANT_TARGETS_PROPERTY = "sonar.jacoco.antTargets";
    public static final String ANT_TARGETS_DEFAULT_VALUE = "";
    private Settings settings;
    private JaCoCoAgentDownloader downloader;

    public JacocoConfiguration(Settings settings, JaCoCoAgentDownloader downloader) {
        this.settings = settings;
        this.downloader = downloader;
    }

    public String getReportPath() {
        return this.settings.getString(REPORT_PATH_PROPERTY);
    }

    public String getItReportPath() {
        return this.settings.getString(IT_REPORT_PATH_PROPERTY);
    }

    public String getJvmArgument() {
        String exclclassloader;
        String excludes;
        AgentOptions options = new AgentOptions();
        options.setDestfile(this.getReportPath());
        String includes = this.settings.getString(INCLUDES_PROPERTY);
        if (StringUtils.isNotBlank((String)includes)) {
            options.setIncludes(includes);
        }
        if (StringUtils.isNotBlank((String)(excludes = this.settings.getString(EXCLUDES_PROPERTY)))) {
            options.setExcludes(excludes);
        }
        if (StringUtils.isNotBlank((String)(exclclassloader = this.settings.getString(EXCLCLASSLOADER_PROPERTY)))) {
            options.setExclClassloader(exclclassloader);
        }
        return options.getVMArgument(this.downloader.getAgentJarFile());
    }

    public String[] getAntTargets() {
        return this.settings.getStringArray(ANT_TARGETS_PROPERTY);
    }

    public String getExcludes() {
        return this.settings.getString(EXCLUDES_PROPERTY);
    }
}

