/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.ui;

import java.awt.Color;
import org.sonar.ide.shared.violations.ViolationUtils;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Violation;

public final class IconsUtils {
    private static final Color[] VIOLATION_COLOR = new Color[]{Color.RED, Color.RED, Color.YELLOW, Color.YELLOW, Color.YELLOW};
    protected static final String IMAGES_PATH = "/org/sonar/ide/images/";

    public static String getIconPath(Violation violation) {
        return "/org/sonar/ide/images/violation.png";
    }

    public static String getPriorityIconPath(Violation violation) {
        String priority = violation.getPriority();
        return "/org/sonar/ide/images/priority/" + priority.toLowerCase() + ".gif";
    }

    public static String getTendencyIconPath(Measure measure, boolean small) {
        Integer trend = measure.getTrend();
        Integer var = measure.getVar();
        if (trend == null || var == null) {
            return null;
        }
        if (var == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(IMAGES_PATH);
        sb.append("tendency/");
        sb.append(var);
        switch (trend) {
            case 0: {
                sb.append("-black");
                break;
            }
            case -1: {
                sb.append("-red");
                break;
            }
            case 1: {
                sb.append("-green");
                break;
            }
        }
        if (small) {
            sb.append("-small");
        }
        sb.append(".png");
        return sb.toString();
    }

    public static String getTendencyIconPath(Measure measure) {
        return IconsUtils.getTendencyIconPath(measure, false);
    }

    public static Color getColor(Violation violation) {
        String priority = violation.getPriority();
        return VIOLATION_COLOR[ViolationUtils.convertPriority(priority)];
    }

    private IconsUtils() {
    }
}

