/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.shared.coverage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sonar.ide.shared.coverage.CoverageLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoverageData {
    private Map<Integer, String> hitsByLine = new HashMap<Integer, String>();
    private Map<Integer, String> branchHitsByLine = new HashMap<Integer, String>();

    public CoverageData(Map<Integer, String> hitsByLine, Map<Integer, String> branchHitsByLine) {
        this.hitsByLine = hitsByLine;
        this.branchHitsByLine = branchHitsByLine;
    }

    public String getHitsByLine(int line) {
        return this.hitsByLine.get(line);
    }

    public String getBranchHitsByLine(int line) {
        return this.branchHitsByLine.get(line);
    }

    public CoverageStatus getCoverageStatus(int line) {
        boolean branchIsCovered;
        String hits = this.hitsByLine.get(line);
        String branchHits = this.branchHitsByLine.get(line);
        boolean hasLineCoverage = null != hits;
        boolean hasBranchCoverage = null != branchHits;
        boolean lineIsCovered = hasLineCoverage && Integer.parseInt(hits) > 0;
        boolean bl = branchIsCovered = hasBranchCoverage && "100%".equals(branchHits);
        if (lineIsCovered) {
            if (branchIsCovered) {
                return CoverageStatus.FULLY_COVERED;
            }
            if (hasBranchCoverage) {
                return CoverageStatus.PARTIALLY_COVERED;
            }
            return CoverageStatus.FULLY_COVERED;
        }
        if (hasLineCoverage) {
            return CoverageStatus.UNCOVERED;
        }
        return CoverageStatus.NO_DATA;
    }

    public Collection<CoverageLine> getCoverageLines() {
        ArrayList<CoverageLine> coverageLines = new ArrayList<CoverageLine>();
        for (Integer line : this.hitsByLine.keySet()) {
            coverageLines.add(new CoverageLine(line, this.hitsByLine.get(line), this.branchHitsByLine.get(line)));
        }
        return coverageLines;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CoverageStatus {
        NO_DATA,
        FULLY_COVERED,
        PARTIALLY_COVERED,
        UNCOVERED;

    }
}

