/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.shared;

import org.apache.commons.lang.StringUtils;

public final class SonarUrlUtils {
    public static final String HOST_DEFAULT = "http://localhost:9000";
    private static final String PROJECT = "/project/index/";
    private static final String COMPONENTS = "/components/index/";
    private static final String RESOURCE = "/resource/index/";
    private static final String TIMEMACHINE = "/timemachine/index/";
    private static final String MEASURES_DRILLDOWN = "/drilldown/measures/";
    private static final String VIOLATIONS_DRILLDOWN = "/drilldown/violations/";

    public static String getDashboard(String host, String resourceKey) {
        return SonarUrlUtils.getUrlBuilder(host, PROJECT, resourceKey).toString();
    }

    public static String getComponents(String host, String resourceKey) {
        return SonarUrlUtils.getUrlBuilder(host, COMPONENTS, resourceKey).toString();
    }

    public static String getResource(String host, String resourceKey) {
        return SonarUrlUtils.getUrlBuilder(host, RESOURCE, resourceKey).toString();
    }

    public static String getTimemachine(String host, String resourceKey) {
        return SonarUrlUtils.getUrlBuilder(host, TIMEMACHINE, resourceKey).toString();
    }

    public static String getMeasuresDrilldown(String host, String resourceKey, String metric) {
        StringBuilder url = SonarUrlUtils.getUrlBuilder(host, MEASURES_DRILLDOWN, resourceKey);
        SonarUrlUtils.append(url, "metric", metric);
        return url.toString();
    }

    public static String getMeasuresDrilldown(String host, String resourceKey) {
        return SonarUrlUtils.getMeasuresDrilldown(host, resourceKey, null);
    }

    public static String getViolationsDrilldown(String host, String resourceKey) {
        return SonarUrlUtils.getUrlBuilder(host, VIOLATIONS_DRILLDOWN, resourceKey).toString();
    }

    private static StringBuilder getUrlBuilder(String host, String prefix, String resourceKey) {
        StringBuilder sb = new StringBuilder().append(host).append(prefix);
        if (StringUtils.isNotBlank((String)resourceKey)) {
            sb.append(resourceKey);
        }
        sb.append("?");
        return sb;
    }

    private static void append(StringBuilder url, String paramKey, String paramValue) {
        if (StringUtils.isNotBlank((String)paramValue)) {
            url.append(paramKey).append('=').append(paramValue).append('&');
        }
    }

    private SonarUrlUtils() {
    }
}

