/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.shared;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectProperties<MODEL> {
    private static final String P_SONAR_SERVER_URL = "sonarServerUrl";
    private static final String P_PROJECT_GROUPID = "projectGroupId";
    private static final String P_PROJECT_ARTIFACTID = "projectArtifactId";
    private static final String P_PROJECT_BRANCH = "projectBranch";
    private static Map<String, AbstractProjectProperties> projectPropertiesMap = new HashMap<String, AbstractProjectProperties>();
    private MODEL project = null;

    protected AbstractProjectProperties(MODEL project) {
        this.project = project;
        projectPropertiesMap.put(this.getProjectName(), this);
        this.load();
    }

    public abstract void save();

    public abstract void load();

    public String getUrl() {
        return this.getProperty(P_SONAR_SERVER_URL, "");
    }

    public void setUrl(String url) {
        this.setProperty(P_SONAR_SERVER_URL, url);
    }

    public String getGroupId() {
        return this.getProperty(P_PROJECT_GROUPID, "");
    }

    public void setGroupId(String groupId) {
        this.setProperty(P_PROJECT_GROUPID, groupId);
    }

    public String getArtifactId() {
        return this.getProperty(P_PROJECT_ARTIFACTID, this.getProjectName());
    }

    public void setArtifactId(String artifactId) {
        this.setProperty(P_PROJECT_ARTIFACTID, artifactId);
    }

    public String getBranch() {
        return this.getProperty(P_PROJECT_BRANCH, "");
    }

    public void setBranch(String branch) {
        this.setProperty(P_PROJECT_BRANCH, branch);
    }

    protected MODEL getProject() {
        return this.project;
    }

    protected static AbstractProjectProperties find(String name) {
        return projectPropertiesMap.get(name);
    }

    protected abstract String getProjectName();

    protected abstract String getProperty(String var1, String var2);

    protected abstract void setProperty(String var1, String var2);
}

