/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.client;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.ide.wsclient.HttpClient3ConnectorFactory;
import org.sonar.wsclient.Host;
import org.sonar.wsclient.Sonar;
import org.sonar.wsclient.connectors.ConnectionException;
import org.sonar.wsclient.connectors.Connector;
import org.sonar.wsclient.services.Model;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Server;
import org.sonar.wsclient.services.ServerQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class SonarClient
extends Sonar {
    private static final Logger LOG = LoggerFactory.getLogger(SonarClient.class);
    private boolean available;
    private int serverTrips = 0;

    public SonarClient(String host) {
        this(host, "", "");
    }

    public SonarClient(String host, String username, String password) {
        super((Connector)HttpClient3ConnectorFactory.createConnector(new Host(host, username, password)));
        this.connect();
    }

    private void connect() {
        try {
            LOG.info("Connect");
            ServerQuery serverQuery = new ServerQuery();
            Server server = (Server)this.find((Query)serverQuery);
            this.available = this.checkVersion(server);
            LOG.info(this.available ? "Connected to " + server.getId() + "(" + server.getVersion() + ")" : "Unable to connect");
        }
        catch (ConnectionException e) {
            this.available = false;
            LOG.error("Unable to connect", (Throwable)e);
        }
    }

    private boolean checkVersion(Server server) {
        if (server == null) {
            return false;
        }
        String version = server.getVersion();
        return version != null && version.startsWith("2.");
    }

    public <MODEL extends Model> MODEL find(Query<MODEL> query) {
        ++this.serverTrips;
        LOG.info("find : {}", (Object)query.getUrl());
        Model model = super.find(query);
        LOG.info(model.toString());
        return (MODEL)model;
    }

    public <MODEL extends Model> List<MODEL> findAll(Query<MODEL> query) {
        ++this.serverTrips;
        LOG.info("find : {}", (Object)query.getUrl());
        List result = super.findAll(query);
        LOG.info("Retrieved {} elements.", (Object)result.size());
        return result;
    }

    public int getServerTrips() {
        return this.serverTrips;
    }

    public boolean isAvailable() {
        return this.available;
    }
}

