/*
 * Decompiled with CFR 0.152.
 */
package org.sca4j.host.domain;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.sca4j.host.domain.AssemblyFailure;
import org.sca4j.host.domain.DeploymentException;

public class AssemblyException
extends DeploymentException {
    private static final long serialVersionUID = 3957908169593535300L;
    private static final Comparator<AssemblyFailure> COMPARATOR = new Comparator<AssemblyFailure>(){

        @Override
        public int compare(AssemblyFailure first, AssemblyFailure second) {
            return first.getComponentUri().compareTo(second.getComponentUri());
        }
    };
    private final List<AssemblyFailure> errors;
    private final List<AssemblyFailure> warnings;

    public AssemblyException(List<AssemblyFailure> errors, List<AssemblyFailure> warnings) {
        this.errors = errors;
        this.warnings = warnings;
    }

    @Override
    public String getMessage() {
        ArrayList<AssemblyFailure> sorted;
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(bas);
        if (!this.errors.isEmpty()) {
            sorted = new ArrayList<AssemblyFailure>(this.errors);
            Collections.sort(sorted, COMPARATOR);
            for (AssemblyFailure error : sorted) {
                writer.write(error.getMessage());
                writer.write("\n\n");
            }
        }
        if (!this.warnings.isEmpty()) {
            sorted = new ArrayList<AssemblyFailure>(this.warnings);
            Collections.sort(sorted, COMPARATOR);
            for (AssemblyFailure warning : sorted) {
                writer.write(warning.getMessage());
            }
        }
        writer.flush();
        return bas.toString();
    }
}

