/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.attributes;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.codehaus.plexus.components.io.attributes.AttributeParser;
import org.codehaus.plexus.components.io.attributes.Java7FileAttributes;
import org.codehaus.plexus.components.io.attributes.Java7Reflector;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.attributes.SimpleResourceAttributes;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineCallable;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlexusIoResourceAttributeUtils {
    static final Pattern totalLinePattern = Pattern.compile("\\w*\\s\\d*");

    private PlexusIoResourceAttributeUtils() {
    }

    public static PlexusIoResourceAttributes mergeAttributes(PlexusIoResourceAttributes override, PlexusIoResourceAttributes base, PlexusIoResourceAttributes def) {
        if (override == null) {
            return base;
        }
        SimpleResourceAttributes result = base == null ? new SimpleResourceAttributes() : new SimpleResourceAttributes(base.getUserId(), base.getUserName(), base.getGroupId(), base.getGroupName(), base.getOctalMode());
        if (override.getGroupId() != null && override.getGroupId() != -1) {
            result.setGroupId(override.getGroupId());
        }
        if (def != null && def.getGroupId() >= 0 && (result.getGroupId() == null || result.getGroupId() < 0)) {
            result.setGroupId(def.getGroupId());
        }
        if (override.getGroupName() != null) {
            result.setGroupName(override.getGroupName());
        }
        if (def != null && result.getGroupName() == null) {
            result.setGroupName(def.getGroupName());
        }
        if (override.getUserId() != null && override.getUserId() != -1) {
            result.setUserId(override.getUserId());
        }
        if (def != null && def.getUserId() >= 0 && (result.getUserId() == null || result.getUserId() < 0)) {
            result.setUserId(def.getUserId());
        }
        if (override.getUserName() != null) {
            result.setUserName(override.getUserName());
        }
        if (def != null && result.getUserName() == null) {
            result.setUserName(def.getUserName());
        }
        if (override.getOctalMode() > 0) {
            result.setOctalMode(override.getOctalMode());
        }
        if (def != null && result.getOctalMode() < 0) {
            result.setOctalMode(def.getOctalMode());
        }
        return result;
    }

    public static boolean isGroupExecutableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 8);
    }

    public static boolean isGroupReadableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 32);
    }

    public static boolean isGroupWritableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 16);
    }

    public static boolean isOwnerExecutableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 64);
    }

    public static boolean isOwnerReadableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 256);
    }

    public static boolean isOwnerWritableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 128);
    }

    public static boolean isWorldExecutableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 1);
    }

    public static boolean isWorldReadableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 4);
    }

    public static boolean isWorldWritableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 2);
    }

    public static boolean isOctalModeEnabled(int mode, int targetMode) {
        return (mode & targetMode) != 0;
    }

    public static PlexusIoResourceAttributes getFileAttributes(File file) throws IOException {
        Map<String, PlexusIoResourceAttributes> byPath = PlexusIoResourceAttributeUtils.getFileAttributesByPath(file, false, true);
        PlexusIoResourceAttributes o = byPath.get(file.getAbsolutePath());
        if (o == null) {
            return SimpleResourceAttributes.lastResortDummyAttributesForBrokenOS();
        }
        return o;
    }

    public static Map<String, PlexusIoResourceAttributes> getFileAttributesByPath(File dir) throws IOException {
        return PlexusIoResourceAttributeUtils.getFileAttributesByPath(dir, true, true);
    }

    public static Map<String, PlexusIoResourceAttributes> getFileAttributesByPath(File dir, boolean recursive, boolean includeNumericUserId) throws IOException {
        if (Java7Reflector.isAtLeastJava7()) {
            return PlexusIoResourceAttributeUtils.getFileAttributesByPathJava7(dir, recursive);
        }
        if (!PlexusIoResourceAttributeUtils.enabledOnCurrentOperatingSystem()) {
            return Collections.emptyMap();
        }
        return PlexusIoResourceAttributeUtils.getFileAttributesByPathScreenScrape(dir, recursive, includeNumericUserId);
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 0) {
            System.out.println("You must supply one directory to scan:");
            return;
        }
        File dir = new File(args[0]);
        Map<String, PlexusIoResourceAttributes> fileAttributesByPathScreenScrape = PlexusIoResourceAttributeUtils.getFileAttributesByPathScreenScrape(dir, true, true);
        for (String s : fileAttributesByPathScreenScrape.keySet()) {
            System.out.println(s + ":" + fileAttributesByPathScreenScrape.get(s));
        }
    }

    static Map<String, PlexusIoResourceAttributes> getFileAttributesByPathScreenScrape(File dir, boolean recursive, boolean includeNumericUserId) throws IOException {
        StringBuilder loggerCache = new StringBuilder();
        StreamConsumer logger = PlexusIoResourceAttributeUtils.createStringBuilderStreamConsumer(loggerCache);
        AttributeParser.NumericUserIDAttributeParser numericIdParser = null;
        FutureTask integerFutureTask = null;
        if (includeNumericUserId) {
            numericIdParser = new AttributeParser.NumericUserIDAttributeParser(logger);
            String lsOptions1 = "-1nla" + (recursive ? "R" : "d");
            ErrorMessageStreamConsumer stdErr = new ErrorMessageStreamConsumer();
            try {
                Commandline numericCli = PlexusIoResourceAttributeUtils.setupCommandLine(dir, lsOptions1, logger);
                CommandLineCallable commandLineCallable = CommandLineUtils.executeCommandLineAsCallable((Commandline)numericCli, null, (StreamConsumer)numericIdParser, (StreamConsumer)stdErr, (int)0);
                integerFutureTask = new FutureTask(commandLineCallable);
                new Thread(integerFutureTask).start();
            }
            catch (CommandLineException e) {
                IOException error = new IOException("Failed to quote directory: '" + dir + "'\n" + ((Object)stdErr).toString() + logger.toString());
                error.initCause(e);
                throw error;
            }
        }
        AttributeParser.SymbolicUserIDAttributeParser userId = PlexusIoResourceAttributeUtils.getNameBasedParser(dir, logger, recursive);
        if (includeNumericUserId) {
            Integer result;
            try {
                result = (Integer)integerFutureTask.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            if (result != 0) {
                throw new IOException("Failed (3) to retrieve numeric file attributes using:\n" + logger.toString());
            }
        }
        return userId.merge(numericIdParser);
    }

    private static AttributeParser.SymbolicUserIDAttributeParser getNameBasedParser(File dir, StreamConsumer logger, boolean recursive) throws IOException {
        AttributeParser.SymbolicUserIDAttributeParser userId = new AttributeParser.SymbolicUserIDAttributeParser(logger);
        ErrorMessageStreamConsumer stdErr = new ErrorMessageStreamConsumer();
        String lsOptions2 = "-1la" + (recursive ? "R" : "d");
        try {
            PlexusIoResourceAttributeUtils.executeLs(dir, lsOptions2, userId, logger);
        }
        catch (CommandLineException e) {
            IOException error = new IOException("Failed to quote directory: '" + dir + "'\n" + ((Object)stdErr).toString() + logger.toString());
            error.initCause(e);
            throw error;
        }
        return userId;
    }

    @Nonnull
    private static Map<String, PlexusIoResourceAttributes> getFileAttributesByPathJava7(@Nonnull File dir, boolean recursive) throws IOException {
        HashMap<Integer, String> userCache = new HashMap<Integer, String>();
        HashMap<Integer, String> groupCache = new HashMap<Integer, String>();
        List fileAndDirectoryNames = recursive && dir.isDirectory() ? FileUtils.getFileAndDirectoryNames((File)dir, null, null, (boolean)true, (boolean)true, (boolean)true, (boolean)true) : Collections.singletonList(dir.getAbsolutePath());
        LinkedHashMap<String, PlexusIoResourceAttributes> attributesByPath = new LinkedHashMap<String, PlexusIoResourceAttributes>();
        for (String fileAndDirectoryName : fileAndDirectoryNames) {
            attributesByPath.put(fileAndDirectoryName, new Java7FileAttributes(new File(fileAndDirectoryName), userCache, groupCache));
        }
        return attributesByPath;
    }

    private static boolean enabledOnCurrentOperatingSystem() {
        return !Os.isFamily((String)"windows") && !Os.isFamily((String)"win9x");
    }

    private static void executeLs(File dir, String options, StreamConsumer parser, StreamConsumer logger) throws IOException, CommandLineException {
        Commandline numericCli = PlexusIoResourceAttributeUtils.setupCommandLine(dir, options, logger);
        ErrorMessageStreamConsumer stdErr = new ErrorMessageStreamConsumer();
        try {
            int result = CommandLineUtils.executeCommandLine((Commandline)numericCli, (StreamConsumer)parser, (StreamConsumer)stdErr);
            if (result != 0) {
                throw new IOException(((Object)stdErr).toString() + "When scraping numeric file attributes:\n" + logger.toString());
            }
        }
        catch (CommandLineException e) {
            IOException error = new IOException("Failed (2) to retrieve numeric file attributes using:\n" + ((Object)stdErr).toString() + "\n" + logger.toString());
            error.initCause(e);
            throw error;
        }
    }

    private static Commandline setupCommandLine(@Nonnull File dir, String options, StreamConsumer logger) {
        Commandline numericCli = new Commandline();
        numericCli.getShell().setQuotedArgumentsEnabled(true);
        numericCli.getShell().setQuotedExecutableEnabled(false);
        numericCli.setExecutable("ls");
        numericCli.createArg().setLine(options);
        numericCli.createArg().setValue(dir.getAbsolutePath());
        logger.consumeLine("\nExecuting: " + numericCli.toString() + "\n");
        return numericCli;
    }

    @Nonnull
    private static StreamConsumer createStringBuilderStreamConsumer(final @Nonnull StringBuilder sb) {
        return new StreamConsumer(){

            public synchronized void consumeLine(String line) {
                sb.append(line).append("\n");
            }

            public synchronized String toString() {
                return sb.toString();
            }
        };
    }

    static class ErrorMessageStreamConsumer
    implements StreamConsumer {
        StringBuilder errorOutput = new StringBuilder();

        ErrorMessageStreamConsumer() {
        }

        public synchronized void consumeLine(String line) {
            this.errorOutput.append(line).append("\n");
        }

        public synchronized String toString() {
            return this.errorOutput.toString();
        }
    }
}

