/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.fileselectors;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.MatchPatterns;
import org.codehaus.plexus.util.SelectorUtils;

public class IncludeExcludeFileSelector
implements FileSelector {
    public static final String ROLE_HINT = "standard";
    private static final MatchPatterns ALL_INCLUDES = MatchPatterns.from((String[])new String[]{IncludeExcludeFileSelector.getCanonicalName("**/*")});
    private static final MatchPatterns ZERO_EXCLUDES = MatchPatterns.from((String[])new String[0]);
    private boolean isCaseSensitive = true;
    private boolean useDefaultExcludes = true;
    private String[] includes;
    private String[] excludes;
    private MatchPatterns computedIncludes = ALL_INCLUDES;
    private MatchPatterns computedExcludes = ZERO_EXCLUDES;

    protected boolean isExcluded(String name) {
        return this.computedExcludes.matches(name, this.isCaseSensitive);
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
        if (includes == null) {
            this.computedIncludes = ALL_INCLUDES;
        } else {
            String[] cleaned = new String[includes.length];
            for (int i = 0; i < includes.length; ++i) {
                cleaned[i] = this.asPattern(includes[i]);
            }
            this.computedIncludes = MatchPatterns.from((String[])cleaned);
        }
    }

    private static String getCanonicalName(String pName) {
        return pName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    private String asPattern(String pPattern) {
        String pattern = IncludeExcludeFileSelector.getCanonicalName(pPattern.trim());
        if (pattern.endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setExcludes(String[] excludes) {
        String[] defaultExcludes;
        this.excludes = excludes;
        String[] stringArray = defaultExcludes = this.useDefaultExcludes ? FileUtils.getDefaultExcludes() : new String[]{};
        if (excludes == null) {
            this.computedExcludes = MatchPatterns.from((String[])defaultExcludes);
        } else {
            String[] temp = new String[excludes.length + defaultExcludes.length];
            for (int i = 0; i < excludes.length; ++i) {
                temp[i] = this.asPattern(excludes[i]);
            }
            if (defaultExcludes.length > 0) {
                System.arraycopy(defaultExcludes, 0, temp, excludes.length, defaultExcludes.length);
            }
            this.computedExcludes = MatchPatterns.from((String[])temp);
        }
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    protected boolean matchPath(String pattern, String name, boolean isCaseSensitive) {
        return SelectorUtils.matchPath((String)pattern, (String)name, (boolean)isCaseSensitive);
    }

    protected boolean isIncluded(String name) {
        return this.computedIncludes.matches(name, this.isCaseSensitive);
    }

    public boolean isSelected(FileInfo fileInfo) throws IOException {
        String name = IncludeExcludeFileSelector.getCanonicalName(fileInfo.getName());
        return this.isIncluded(name) && !this.isExcluded(name);
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
    }

    public boolean isUseDefaultExcludes() {
        return this.useDefaultExcludes;
    }

    public void setUseDefaultExcludes(boolean pUseDefaultExcludes) {
        this.useDefaultExcludes = pUseDefaultExcludes;
        this.setExcludes(this.excludes);
    }
}

