/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.repository.io;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentRequirementList;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.io.XmlPlexusConfigurationReader;

public class PlexusTools {
    public static PlexusConfiguration buildConfiguration(String resourceName, Reader configuration) throws PlexusConfigurationException {
        try {
            XmlPlexusConfigurationReader reader = new XmlPlexusConfigurationReader();
            PlexusConfiguration result = reader.read(configuration);
            return result;
        }
        catch (PlexusConfigurationException e) {
            throw new PlexusConfigurationException("PlexusConfigurationException building configuration from: " + resourceName, e);
        }
        catch (IOException e) {
            throw new PlexusConfigurationException("IO error building configuration from: " + resourceName, e);
        }
    }

    public static PlexusConfiguration buildConfiguration(String configuration) throws PlexusConfigurationException {
        return PlexusTools.buildConfiguration("<String Memory Resource>", new StringReader(configuration));
    }

    public static ComponentDescriptor buildComponentDescriptor(String configuration) throws PlexusConfigurationException {
        return PlexusTools.buildComponentDescriptor(PlexusTools.buildConfiguration(configuration));
    }

    public static ComponentDescriptor buildComponentDescriptor(PlexusConfiguration configuration) throws PlexusConfigurationException {
        ComponentDescriptor cd = new ComponentDescriptor();
        cd.setRole(configuration.getChild("role").getValue());
        cd.setRoleHint(configuration.getChild("role-hint").getValue());
        cd.setImplementation(configuration.getChild("implementation").getValue());
        cd.setVersion(configuration.getChild("version").getValue());
        cd.setComponentType(configuration.getChild("component-type").getValue());
        cd.setInstantiationStrategy(configuration.getChild("instantiation-strategy").getValue());
        cd.setLifecycleHandler(configuration.getChild("lifecycle-handler").getValue());
        cd.setComponentProfile(configuration.getChild("component-profile").getValue());
        cd.setComponentComposer(configuration.getChild("component-composer").getValue());
        cd.setComponentConfigurator(configuration.getChild("component-configurator").getValue());
        cd.setComponentFactory(configuration.getChild("component-factory").getValue());
        cd.setDescription(configuration.getChild("description").getValue());
        cd.setAlias(configuration.getChild("alias").getValue());
        String s = configuration.getChild("isolated-realm").getValue();
        if (s != null) {
            cd.setIsolatedRealm(s.equals("true"));
        }
        cd.setConfiguration(configuration.getChild("configuration"));
        PlexusConfiguration[] requirements = configuration.getChild("requirements").getChildren("requirement");
        int i = 0;
        while (i < requirements.length) {
            ComponentRequirement cr;
            PlexusConfiguration requirement = requirements[i];
            PlexusConfiguration[] hints = requirement.getChild("role-hints").getChildren("role-hint");
            if (hints != null && hints.length > 0) {
                cr = new ComponentRequirementList();
                LinkedList<String> hintList = new LinkedList<String>();
                int j = 0;
                while (j < hints.length) {
                    hintList.add(hints[j].getValue());
                    ++j;
                }
                ((ComponentRequirementList)cr).setRoleHints(hintList);
            } else {
                cr = new ComponentRequirement();
                cr.setRoleHint(requirement.getChild("role-hint").getValue());
            }
            cr.setRole(requirement.getChild("role").getValue());
            cr.setFieldName(requirement.getChild("field-name").getValue());
            cd.addRequirement(cr);
            ++i;
        }
        return cd;
    }

    public static ComponentSetDescriptor buildComponentSet(PlexusConfiguration c) throws PlexusConfigurationException {
        ComponentSetDescriptor csd = new ComponentSetDescriptor();
        PlexusConfiguration[] components = c.getChild("components").getChildren("component");
        int i = 0;
        while (i < components.length) {
            PlexusConfiguration component = components[i];
            csd.addComponentDescriptor(PlexusTools.buildComponentDescriptor(component));
            ++i;
        }
        PlexusConfiguration[] dependencies = c.getChild("dependencies").getChildren("dependency");
        int i2 = 0;
        while (i2 < dependencies.length) {
            PlexusConfiguration d = dependencies[i2];
            ComponentDependency cd = new ComponentDependency();
            cd.setArtifactId(d.getChild("artifact-id").getValue());
            cd.setGroupId(d.getChild("group-id").getValue());
            String type = d.getChild("type").getValue();
            if (type != null) {
                cd.setType(type);
            }
            cd.setVersion(d.getChild("version").getValue());
            csd.addDependency(cd);
            ++i2;
        }
        return csd;
    }

    public static void writeConfiguration(PrintStream out, PlexusConfiguration configuration) throws PlexusConfigurationException {
        PlexusTools.writeConfiguration(out, configuration, "");
    }

    private static void writeConfiguration(PrintStream out, PlexusConfiguration configuration, String indent) throws PlexusConfigurationException {
        out.print(String.valueOf(indent) + "<" + configuration.getName());
        String[] atts = configuration.getAttributeNames();
        if (atts.length > 0) {
            int i = 0;
            while (i < atts.length) {
                out.print("\n" + indent + "  " + atts[i] + "='" + configuration.getAttribute(atts[i]) + "'");
                ++i;
            }
        }
        PlexusConfiguration[] pc = configuration.getChildren();
        if (configuration.getValue() != null && configuration.getValue().trim().length() > 0 || pc.length > 0) {
            out.print(">" + (configuration.getValue() == null ? "" : configuration.getValue().trim()));
            if (pc.length > 0) {
                out.println();
                int i = 0;
                while (i < pc.length) {
                    PlexusTools.writeConfiguration(out, pc[i], String.valueOf(indent) + "  ");
                    ++i;
                }
                out.print(indent);
            }
            out.println("</" + configuration.getName() + ">");
        } else {
            out.println("/>");
        }
    }
}

