/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata.ann;

import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.plexus.metadata.ann.Ann;
import org.codehaus.plexus.metadata.ann.AnnClass;
import org.objectweb.asm.Type;

public class AnnField {
    private final AnnClass owner;
    private final int access;
    private final String name;
    private final String desc;
    private Map<String, Ann> anns = new LinkedHashMap<String, Ann>();

    public AnnField(AnnClass owner, int access, String name, String desc) {
        this.owner = owner;
        this.access = access;
        this.desc = desc;
        this.name = name;
    }

    public int getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public Map<String, Ann> getAnns() {
        return this.anns;
    }

    public String getType() {
        return Type.getType((String)this.desc).getClassName();
    }

    public void addAnn(Ann ann) {
        this.anns.put(ann.getDesc(), ann);
    }

    public <T> T getAnnotation(Class<T> c) {
        Ann ann = this.anns.get(Type.getDescriptor(c));
        return ann == null ? null : (T)ann.getAnnotation(c, this.owner.getClassLoader());
    }
}

