/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.metadata.ComponentDescriptorExtractorSupport;
import org.codehaus.plexus.metadata.ExtractorConfiguration;
import org.codehaus.plexus.metadata.gleaner.AnnotationComponentGleaner;
import org.codehaus.plexus.metadata.gleaner.ClassComponentGleaner;
import org.codehaus.plexus.util.DirectoryScanner;

public class ClassComponentDescriptorExtractor
extends ComponentDescriptorExtractorSupport {
    private ClassComponentGleaner gleaner;

    public ClassComponentDescriptorExtractor(ClassComponentGleaner gleaner) {
        this.gleaner = gleaner;
    }

    public ClassComponentDescriptorExtractor() {
        this.gleaner = new AnnotationComponentGleaner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List extract(ExtractorConfiguration configuration, ComponentDescriptor[] roleDefaults) throws Exception {
        assert (roleDefaults != null);
        if (this.gleaner == null) {
            throw new IllegalStateException("Gleaner is not bound");
        }
        if (!configuration.outputDirectory.exists()) {
            return Collections.EMPTY_LIST;
        }
        ClassLoader prev = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = this.createClassLoader(configuration.classpath);
        Thread.currentThread().setContextClassLoader(cl);
        try {
            List list = this.extract(configuration.outputDirectory, cl, this.getDefaultsByRole(roleDefaults));
            return list;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prev);
        }
    }

    private ClassLoader createClassLoader(List elements) throws Exception {
        ArrayList<URL> list = new ArrayList<URL>();
        for (String filename : elements) {
            try {
                list.add(new File(filename).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Invalid classpath entry: " + filename, (Exception)e);
            }
        }
        URL[] urls = list.toArray(new URL[list.size()]);
        for (int i = 0; i < urls.length; ++i) {
        }
        return new URLClassLoader(urls, this.getClass().getClassLoader());
    }

    private List extract(File classesDir, ClassLoader cl, Map defaultsByRole) throws Exception {
        assert (classesDir != null);
        assert (cl != null);
        assert (defaultsByRole != null);
        ArrayList<ComponentDescriptor> descriptors = new ArrayList<ComponentDescriptor>();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(classesDir);
        scanner.addDefaultExcludes();
        scanner.setIncludes(new String[]{"**/*.class"});
        scanner.scan();
        String[] includes = scanner.getIncludedFiles();
        for (int i = 0; i < includes.length; ++i) {
            String className = includes[i].substring(0, includes[i].lastIndexOf(".class")).replace('\\', '.').replace('/', '.');
            try {
                Class<?> type = cl.loadClass(className);
                ComponentDescriptor descriptor = this.gleaner.glean(type);
                if (descriptor == null) continue;
                this.applyDefaults(descriptor, defaultsByRole);
                descriptors.add(descriptor);
                continue;
            }
            catch (VerifyError e) {
                // empty catch block
            }
        }
        return descriptors;
    }
}

