/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.eclipse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.eclipse.SourceCodeLocator;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public class EclipseJavaCompiler
extends AbstractCompiler {
    boolean errorsAsWarnings = false;

    public EclipseJavaCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        String targetVersion;
        String sourceVersion;
        LinkedList<CompilerMessage> errors = new LinkedList<CompilerMessage>();
        List classpathEntries = config.getClasspathEntries();
        URL[] urls = new URL[1 + classpathEntries.size()];
        int i = 0;
        try {
            urls[i++] = new File(config.getOutputLocation()).toURL();
            for (String entry : classpathEntries) {
                urls[i++] = new File(entry).toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new CompilerException("Error while converting the classpath entries to URLs.", (Throwable)e);
        }
        URLClassLoader classLoader = new URLClassLoader(urls);
        SourceCodeLocator sourceCodeLocator = new SourceCodeLocator(config.getSourceLocations());
        EclipseCompilerINameEnvironment env = new EclipseCompilerINameEnvironment(sourceCodeLocator, classLoader, errors);
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        HashMap<String, String> settings = new HashMap<String, String>();
        if (config.isDebug()) {
            settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
            settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
            settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        }
        if (!config.isShowWarnings()) {
            Map opts = new CompilerOptions().getMap();
            for (Object optKey : opts.keySet()) {
                if (!opts.get(optKey).equals("warning")) continue;
                settings.put((String)optKey, "ignore");
            }
        }
        if ((sourceVersion = this.decodeVersion(config.getSourceVersion())) != null) {
            settings.put("org.eclipse.jdt.core.compiler.source", sourceVersion);
        }
        if ((targetVersion = this.decodeVersion(config.getTargetVersion())) != null) {
            settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", targetVersion);
            settings.put("org.eclipse.jdt.core.compiler.compliance", targetVersion);
        }
        if (StringUtils.isNotEmpty((String)config.getSourceEncoding())) {
            settings.put("org.eclipse.jdt.core.encoding", config.getSourceEncoding());
        }
        if (config.isShowDeprecation()) {
            settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        } else {
            settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        }
        if (config.isParameters()) {
            settings.put("org.eclipse.jdt.core.compiler.codegen.methodParameters", "generate");
        }
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        Map<String, String> extras = this.cleanKeyNames(config.getCustomCompilerArgumentsAsMap());
        if (extras.containsKey("errorsAsWarnings")) {
            extras.remove("errorsAsWarnings");
            this.errorsAsWarnings = true;
        }
        settings.putAll(extras);
        if (settings.containsKey("properties")) {
            this.initializeWarnings((String)settings.get("properties"), settings);
            settings.remove("properties");
        }
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        EclipseCompilerICompilerRequestor requestor = new EclipseCompilerICompilerRequestor(config.getOutputLocation(), errors);
        ArrayList<CompilationUnit> compilationUnits = new ArrayList<CompilationUnit>();
        for (String sourceRoot : config.getSourceLocations()) {
            File potentialSourceDirectory = new File(sourceRoot);
            if (!potentialSourceDirectory.exists()) continue;
            Set sources = EclipseJavaCompiler.getSourceFilesForSourceRoot((CompilerConfiguration)config, (String)sourceRoot);
            for (String source : sources) {
                CompilationUnit unit = new CompilationUnit(source, EclipseJavaCompiler.makeClassName((String)source, (String)sourceRoot), errors, config.getSourceEncoding());
                compilationUnits.add(unit);
            }
        }
        CompilerOptions options = new CompilerOptions(settings);
        Compiler compiler = new Compiler((INameEnvironment)env, policy, options, (ICompilerRequestor)requestor, (IProblemFactory)problemFactory);
        ICompilationUnit[] units = compilationUnits.toArray(new ICompilationUnit[compilationUnits.size()]);
        compiler.compile(units);
        CompilerResult compilerResult = new CompilerResult().compilerMessages(errors);
        for (CompilerMessage compilerMessage : errors) {
            if (!compilerMessage.isError()) continue;
            compilerResult.setSuccess(false);
        }
        return compilerResult;
    }

    Map<String, String> cleanKeyNames(Map<String, String> customCompilerArgumentsAsMap) {
        LinkedHashMap<String, String> cleanedMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : customCompilerArgumentsAsMap.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("-")) {
                key = key.substring(1);
            }
            cleanedMap.put(key, entry.getValue());
        }
        return cleanedMap;
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return null;
    }

    private CompilerMessage handleError(String className, int line, int column, Object errorMessage) {
        if (className.endsWith(".java")) {
            className = className.substring(0, className.lastIndexOf(46));
        }
        String fileName = className.replace('.', File.separatorChar) + ".java";
        if (column < 0) {
            column = 0;
        }
        String message = errorMessage != null ? errorMessage.toString() : "No message";
        return new CompilerMessage(fileName, CompilerMessage.Kind.ERROR, line, column, line, column, message);
    }

    private CompilerMessage handleWarning(String fileName, IProblem warning) {
        return new CompilerMessage(fileName, CompilerMessage.Kind.WARNING, warning.getSourceLineNumber(), warning.getSourceStart(), warning.getSourceLineNumber(), warning.getSourceEnd(), warning.getMessage());
    }

    private String decodeVersion(String versionSpec) {
        if (StringUtils.isEmpty((String)versionSpec)) {
            return null;
        }
        if ("1.1".equals(versionSpec)) {
            return "1.1";
        }
        if ("1.2".equals(versionSpec)) {
            return "1.2";
        }
        if ("1.3".equals(versionSpec)) {
            return "1.3";
        }
        if ("1.4".equals(versionSpec)) {
            return "1.4";
        }
        if ("1.5".equals(versionSpec)) {
            return "1.5";
        }
        if ("1.6".equals(versionSpec)) {
            return "1.6";
        }
        if ("1.7".equals(versionSpec)) {
            return "1.7";
        }
        if ("1.8".equals(versionSpec)) {
            return "1.8";
        }
        if ("9".equals(versionSpec)) {
            return "9";
        }
        this.getLogger().warn("Unknown version '" + versionSpec + "', no version setting will be given to the compiler.");
        return null;
    }

    private void initializeWarnings(String propertiesFile, Map<String, String> setting) {
        File file = new File(propertiesFile);
        if (!file.exists()) {
            throw new IllegalArgumentException("Properties file not exist");
        }
        BufferedInputStream stream = null;
        Properties properties = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(propertiesFile));
            properties = new Properties();
            properties.load(stream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Properties file load error");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            setting.put(key, entry.getValue().toString());
        }
    }

    private class EclipseCompilerICompilerRequestor
    implements ICompilerRequestor {
        private String destinationDirectory;
        private List<CompilerMessage> errors;

        public EclipseCompilerICompilerRequestor(String destinationDirectory, List<CompilerMessage> errors) {
            this.destinationDirectory = destinationDirectory;
            this.errors = errors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Could not resolve type clashes
         * Loose catch block
         */
        public void acceptResult(CompilationResult result) {
            boolean hasErrors = false;
            if (result.hasProblems()) {
                CategorizedProblem[] problems;
                for (CategorizedProblem problem : problems = result.getProblems()) {
                    String name = this.getFileName(result.getCompilationUnit(), problem.getOriginatingFileName());
                    if (problem.isWarning()) {
                        this.errors.add(EclipseJavaCompiler.this.handleWarning(name, (IProblem)problem));
                        continue;
                    }
                    if (EclipseJavaCompiler.this.errorsAsWarnings) {
                        this.errors.add(EclipseJavaCompiler.this.handleWarning(name, (IProblem)problem));
                        continue;
                    }
                    hasErrors = true;
                    this.errors.add(EclipseJavaCompiler.this.handleError(name, problem.getSourceLineNumber(), -1, problem.getMessage()));
                }
            }
            if (!hasErrors) {
                ClassFile[] classFiles = result.getClassFiles();
                for (CategorizedProblem classFile : classFiles) {
                    char[][] compoundName = classFile.getCompoundName();
                    String className = "";
                    String sep = "";
                    for (int j = 0; j < compoundName.length; ++j) {
                        className = className + sep;
                        className = className + new String(compoundName[j]);
                        sep = ".";
                    }
                    byte[] bytes = classFile.getBytes();
                    File outFile = new File(this.destinationDirectory, className.replace('.', '/') + ".class");
                    if (!outFile.getParentFile().exists()) {
                        outFile.getParentFile().mkdirs();
                    }
                    FileOutputStream fout = null;
                    try {
                        fout = new FileOutputStream(outFile);
                        fout.write(bytes);
                    }
                    catch (FileNotFoundException e) {
                        this.errors.add(EclipseJavaCompiler.this.handleError(className, -1, -1, e.getMessage()));
                        IOUtil.close((OutputStream)fout);
                        continue;
                    }
                    catch (IOException e2) {
                        this.errors.add(EclipseJavaCompiler.this.handleError(className, -1, -1, e2.getMessage()));
                        {
                            catch (Throwable throwable) {
                                IOUtil.close(fout);
                                throw throwable;
                            }
                        }
                        IOUtil.close((OutputStream)fout);
                        continue;
                    }
                    IOUtil.close((OutputStream)fout);
                }
            }
        }

        private String getFileName(ICompilationUnit compilationUnit, char[] originalFileName) {
            if (compilationUnit instanceof CompilationUnit) {
                return ((CompilationUnit)compilationUnit).getAbsolutePath();
            }
            return String.valueOf(originalFileName);
        }
    }

    private class EclipseCompilerINameEnvironment
    implements INameEnvironment {
        private SourceCodeLocator sourceCodeLocator;
        private ClassLoader classLoader;
        private List<CompilerMessage> errors;

        public EclipseCompilerINameEnvironment(SourceCodeLocator sourceCodeLocator, ClassLoader classLoader, List<CompilerMessage> errors) {
            this.sourceCodeLocator = sourceCodeLocator;
            this.classLoader = classLoader;
            this.errors = errors;
        }

        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            String result = "";
            String sep = "";
            for (int i = 0; i < compoundTypeName.length; ++i) {
                result = result + sep;
                result = result + new String(compoundTypeName[i]);
                sep = ".";
            }
            return this.findType(result);
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            String result = "";
            String sep = "";
            for (int i = 0; i < packageName.length; ++i) {
                result = result + sep;
                result = result + new String(packageName[i]);
                sep = ".";
            }
            result = result + sep;
            result = result + new String(typeName);
            return this.findType(result);
        }

        private NameEnvironmentAnswer findType(String className) {
            try {
                File f = this.sourceCodeLocator.findSourceCodeForClass(className);
                if (f != null) {
                    CompilationUnit compilationUnit = new CompilationUnit(f.getAbsolutePath(), className, this.errors);
                    return new NameEnvironmentAnswer((ICompilationUnit)compilationUnit, null);
                }
                String resourceName = className.replace('.', '/') + ".class";
                InputStream is = this.classLoader.getResourceAsStream(resourceName);
                if (is == null) {
                    return null;
                }
                byte[] classBytes = IOUtil.toByteArray((InputStream)is);
                char[] fileName = className.toCharArray();
                ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
                return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
            }
            catch (IOException e) {
                this.errors.add(EclipseJavaCompiler.this.handleError(className, -1, -1, e.getMessage()));
                return null;
            }
            catch (ClassFormatException e) {
                this.errors.add(EclipseJavaCompiler.this.handleError(className, -1, -1, e.getMessage()));
                return null;
            }
        }

        private boolean isPackage(String result) {
            if (this.sourceCodeLocator.findSourceCodeForClass(result) != null) {
                return false;
            }
            String resourceName = "/" + result.replace('.', '/') + ".class";
            InputStream is = this.classLoader.getResourceAsStream(resourceName);
            return is == null;
        }

        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            String result = "";
            String sep = "";
            if (parentPackageName != null) {
                for (int i = 0; i < parentPackageName.length; ++i) {
                    result = result + sep;
                    result = result + new String(parentPackageName[i]);
                    sep = ".";
                }
            }
            if (Character.isUpperCase(packageName[0])) {
                return false;
            }
            String str = new String(packageName);
            result = result + sep;
            result = result + str;
            return this.isPackage(result);
        }

        public void cleanup() {
        }
    }

    private class CompilationUnit
    implements ICompilationUnit {
        private final String className;
        private final String sourceFile;
        private final String sourceEncoding;
        private final List<CompilerMessage> errors;

        CompilationUnit(String sourceFile, String className, List<CompilerMessage> errors) {
            this(sourceFile, className, errors, null);
        }

        CompilationUnit(String sourceFile, String className, List<CompilerMessage> errors, String sourceEncoding) {
            this.className = className;
            this.sourceFile = sourceFile;
            this.errors = errors;
            this.sourceEncoding = sourceEncoding;
        }

        public char[] getFileName() {
            String fileName = this.sourceFile;
            int lastSeparator = fileName.lastIndexOf(File.separatorChar);
            if (lastSeparator > 0) {
                fileName = fileName.substring(lastSeparator + 1);
            }
            return fileName.toCharArray();
        }

        String getAbsolutePath() {
            return this.sourceFile;
        }

        public char[] getContents() {
            try {
                return FileUtils.fileRead((String)this.sourceFile, (String)this.sourceEncoding).toCharArray();
            }
            catch (FileNotFoundException e) {
                this.errors.add(EclipseJavaCompiler.this.handleError(this.className, -1, -1, e.getMessage()));
                return null;
            }
            catch (IOException e) {
                this.errors.add(EclipseJavaCompiler.this.handleError(this.className, -1, -1, e.getMessage()));
                return null;
            }
        }

        public char[] getMainTypeName() {
            int dot = this.className.lastIndexOf(46);
            if (dot > 0) {
                return this.className.substring(dot + 1).toCharArray();
            }
            return this.className.toCharArray();
        }

        public char[][] getPackageName() {
            StringTokenizer izer = new StringTokenizer(this.className, ".");
            char[][] result = new char[izer.countTokens() - 1][];
            for (int i = 0; i < result.length; ++i) {
                String tok = izer.nextToken();
                result[i] = tok.toCharArray();
            }
            return result;
        }

        public boolean ignoreOptionalProblems() {
            return false;
        }
    }
}

