/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.eclipse;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.eclipse.EcjFailureException;
import org.codehaus.plexus.compiler.eclipse.EcjResponseParser;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;

@Named(value="eclipse")
@Singleton
public class EclipseJavaCompiler
extends AbstractCompiler {
    boolean errorsAsWarnings = false;
    private static final String OPT_REPLACE_PROCESSOR_PATH = "replaceProcessorPathWithProcessorModulePath";
    private static final String OPT_REPLACE_PROCESSOR_PATH_ = "-replaceProcessorPathWithProcessorModulePath";

    public EclipseJavaCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    public String getCompilerId() {
        return "eclipse";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-noExit");
        if (config.isDebug()) {
            args.add("-preserveAllLocals");
            args.add("-g:lines,vars,source");
        } else {
            args.add("-g:lines,source");
        }
        String releaseVersion = this.decodeVersion(config.getReleaseVersion());
        if (releaseVersion != null) {
            args.add("--release");
            args.add(releaseVersion);
        } else {
            String targetVersion;
            String sourceVersion = this.decodeVersion(config.getSourceVersion());
            if (sourceVersion != null) {
                args.add("-source");
                args.add(sourceVersion);
            }
            if ((targetVersion = this.decodeVersion(config.getTargetVersion())) != null) {
                args.add("-target");
                args.add(targetVersion);
            }
        }
        if (StringUtils.isNotEmpty((String)config.getSourceEncoding())) {
            args.add("-encoding");
            args.add(config.getSourceEncoding());
        }
        if (!config.isShowWarnings()) {
            args.add("-warn:none");
        } else {
            StringBuilder warns;
            String warnings = config.getWarnings();
            StringBuilder stringBuilder = warns = StringUtils.isEmpty((String)warnings) ? new StringBuilder() : new StringBuilder(warnings).append(',');
            if (config.isShowDeprecation()) {
                EclipseJavaCompiler.append(warns, "+deprecation");
            } else {
                EclipseJavaCompiler.append(warns, "-deprecation");
            }
            args.add("-warn:" + String.valueOf(warns));
        }
        if (config.isParameters()) {
            args.add("-parameters");
        }
        if (config.isFailOnWarning()) {
            args.add("-failOnWarning");
        }
        this.errorsAsWarnings = EclipseJavaCompiler.processCustomArguments(config, args);
        args.add("-d");
        args.add(config.getOutputLocation());
        ArrayList<String> classpathEntries = new ArrayList<String>(config.getClasspathEntries());
        classpathEntries.add(config.getOutputLocation());
        args.add("-classpath");
        args.add(EclipseJavaCompiler.getPathString(classpathEntries));
        List modulepathEntries = config.getModulepathEntries();
        if (modulepathEntries != null && !modulepathEntries.isEmpty()) {
            args.add("--module-path");
            args.add(EclipseJavaCompiler.getPathString((List)modulepathEntries));
        }
        if (!this.isPreJava1_6(config)) {
            File generatedSourcesDir = config.getGeneratedSourcesDirectory();
            if (generatedSourcesDir != null) {
                generatedSourcesDir.mkdirs();
                args.add("-s");
                args.add(generatedSourcesDir.getAbsolutePath());
            }
            String[] annotationProcessors = config.getAnnotationProcessors();
            List processorPathEntries = config.getProcessorPathEntries();
            List processorModulePathEntries = config.getProcessorModulePathEntries();
            if (annotationProcessors != null && annotationProcessors.length > 0 || processorPathEntries != null && processorPathEntries.size() > 0 || processorModulePathEntries != null && processorModulePathEntries.size() > 0) {
                if (annotationProcessors != null && annotationProcessors.length > 0) {
                    args.add("-processor");
                    StringBuilder sb = new StringBuilder();
                    for (String string : annotationProcessors) {
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append(string);
                    }
                    args.add(sb.toString());
                }
                if (processorPathEntries != null && processorPathEntries.size() > 0) {
                    if (EclipseJavaCompiler.isReplaceProcessorPath(config)) {
                        args.add("--processor-module-path");
                    } else {
                        args.add("-processorpath");
                    }
                    args.add(EclipseJavaCompiler.getPathString((List)processorPathEntries));
                }
                if (processorModulePathEntries != null && processorModulePathEntries.size() > 0) {
                    args.add("--processor-module-path");
                    args.add(EclipseJavaCompiler.getPathString((List)processorModulePathEntries));
                }
                if (config.getProc() != null) {
                    args.add("-proc:" + config.getProc());
                }
            }
        }
        List<String> allSources = Arrays.asList(EclipseJavaCompiler.getSourceFiles((CompilerConfiguration)config));
        List<Object> messageList = new ArrayList();
        if (allSources.isEmpty()) {
            return new CompilerResult(true, messageList);
        }
        allSources = EclipseJavaCompiler.resortSourcesToPutModuleInfoFirst(allSources);
        this.logCompiling(null, config);
        try {
            StringWriter sw = new StringWriter();
            PrintWriter devNull = new PrintWriter(sw);
            JavaCompiler compiler = this.getEcj();
            boolean success = false;
            if (compiler != null) {
                this.getLog().debug("Using JSR-199 EclipseCompiler");
                if (!EclipseJavaCompiler.haveSourceOrReleaseArgument(args)) {
                    this.getLog().debug("ecj: no source level nor release specified, defaulting to Java 8");
                    args.add("-source");
                    args.add("8");
                }
                String encoding = null;
                Iterator allArgs = args.iterator();
                while (encoding == null && allArgs.hasNext()) {
                    String string = (String)allArgs.next();
                    if (!"-encoding".equals(string) || !allArgs.hasNext()) continue;
                    encoding = (String)allArgs.next();
                }
                final Locale locale = Locale.getDefault();
                final ArrayList messages = messageList;
                DiagnosticListener<JavaFileObject> messageCollector = new DiagnosticListener<JavaFileObject>(){
                    final /* synthetic */ EclipseJavaCompiler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                        String fileName = "Unknown source";
                        try {
                            JavaFileObject file = diagnostic.getSource();
                            if (file != null) {
                                fileName = file.getName();
                            }
                        }
                        catch (NullPointerException file) {
                            // empty catch block
                        }
                        long startColumn = diagnostic.getColumnNumber();
                        long endColumn = startColumn + (diagnostic.getEndPosition() - diagnostic.getStartPosition());
                        CompilerMessage message = new CompilerMessage(fileName, this.this$0.convert(diagnostic.getKind()), (int)diagnostic.getLineNumber(), (int)startColumn, (int)diagnostic.getLineNumber(), (int)endColumn, diagnostic.getMessage(locale));
                        messages.add(message);
                    }
                };
                Charset charset = null;
                if (encoding != null) {
                    encoding = encoding.trim();
                    try {
                        charset = Charset.forName(encoding);
                    }
                    catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                        this.getLog().warn("ecj: invalid or unsupported character set '" + encoding + "', using default");
                    }
                }
                if (charset == null) {
                    charset = Charset.defaultCharset();
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug("ecj: using character set " + charset.displayName());
                    this.getLog().debug("ecj command line: " + String.valueOf(args));
                    this.getLog().debug("ecj input source files: " + String.valueOf(allSources));
                }
                try (StandardJavaFileManager manager = compiler.getStandardFileManager((DiagnosticListener<? super JavaFileObject>)messageCollector, locale, charset);){
                    Iterable<? extends JavaFileObject> units = manager.getJavaFileObjectsFromStrings(allSources);
                    success = Boolean.TRUE.equals(compiler.getTask(devNull, manager, (DiagnosticListener<? super JavaFileObject>)messageCollector, args, null, units).call());
                }
                catch (RuntimeException e) {
                    throw new EcjFailureException(e.getLocalizedMessage());
                }
                this.getLog().debug(sw.toString());
            } else {
                File errorF = null;
                try {
                    errorF = File.createTempFile("ecjerr-", ".xml");
                    this.getLog().debug("Using legacy BatchCompiler; error file " + String.valueOf(errorF));
                    args.add("-log");
                    args.add(errorF.toString());
                    args.addAll(allSources);
                    this.getLog().debug("ecj command line: " + String.valueOf(args));
                    success = BatchCompiler.compile((String[])args.toArray(new String[args.size()]), (PrintWriter)devNull, (PrintWriter)devNull, (CompilationProgress)new CompilationProgress(){

                        public void begin(int i) {
                        }

                        public void done() {
                        }

                        public boolean isCanceled() {
                            return false;
                        }

                        public void setTaskName(String s) {
                        }

                        public void worked(int i, int i1) {
                        }
                    });
                    this.getLog().debug(sw.toString());
                    if (errorF.length() < 80L) {
                        throw new EcjFailureException(sw.toString());
                    }
                    messageList = new EcjResponseParser().parse(errorF, this.errorsAsWarnings);
                }
                finally {
                    if (null != errorF) {
                        try {
                            errorF.delete();
                        }
                        catch (Exception allArgs) {}
                    }
                }
            }
            boolean hasError = false;
            for (CompilerMessage compilerMessage : messageList) {
                if (!compilerMessage.isError()) continue;
                hasError = true;
                break;
            }
            if (!(hasError || success || this.errorsAsWarnings)) {
                CompilerMessage.Kind kind = this.errorsAsWarnings ? CompilerMessage.Kind.WARNING : CompilerMessage.Kind.ERROR;
                CompilerMessage compilerMessage = new CompilerMessage("[ecj] The compiler reported an error but has not written it to its logging", kind);
                messageList.add(compilerMessage);
                hasError = true;
                String stdout = this.getLastLines(sw.toString(), 5);
                if (stdout.length() > 0) {
                    CompilerMessage compilerMessage2 = new CompilerMessage("[ecj] The following line(s) might indicate the issue:\n" + stdout, kind);
                    messageList.add(compilerMessage2);
                }
            }
            return new CompilerResult(!hasError || this.errorsAsWarnings, messageList);
        }
        catch (EcjFailureException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    static boolean isReplaceProcessorPath(CompilerConfiguration config) {
        for (Map.Entry entry : config.getCustomCompilerArgumentsEntries()) {
            String opt = (String)entry.getKey();
            if (!opt.equals(OPT_REPLACE_PROCESSOR_PATH) && !opt.equals(OPT_REPLACE_PROCESSOR_PATH_)) continue;
            return true;
        }
        return false;
    }

    static List<String> resortSourcesToPutModuleInfoFirst(List<String> allSources) {
        ArrayList<String> resorted = new ArrayList<String>(allSources.size());
        for (String mi : allSources) {
            if (!mi.endsWith("module-info.java")) continue;
            resorted.add(mi);
        }
        for (String nmi : allSources) {
            if (nmi.endsWith("module-info.java")) continue;
            resorted.add(nmi);
        }
        return resorted;
    }

    static boolean processCustomArguments(CompilerConfiguration config, List<String> args) {
        boolean result = false;
        for (Map.Entry entry : config.getCustomCompilerArgumentsEntries()) {
            File propFile;
            Object opt = (String)entry.getKey();
            String optionValue = (String)entry.getValue();
            if (((String)opt).equals("errorsAsWarnings") || ((String)opt).equals("-errorsAsWarnings")) {
                result = true;
                continue;
            }
            if (!(!((String)opt).equals("-properties") || null == optionValue || (propFile = new File(optionValue)).exists() && propFile.isFile())) {
                throw new IllegalArgumentException("Properties file specified by -properties " + String.valueOf(propFile) + " does not exist");
            }
            if (((String)opt).equals("-proceedOnError")) {
                args.add("-proceedOnError:Fatal");
                continue;
            }
            if (((String)opt).equals(OPT_REPLACE_PROCESSOR_PATH) || ((String)opt).equals(OPT_REPLACE_PROCESSOR_PATH_)) continue;
            if (null == optionValue) {
                args.add((String)opt);
                continue;
            }
            if (!((String)opt).startsWith("-")) {
                opt = "-" + (String)opt;
            }
            args.add((String)opt);
            args.add(optionValue);
        }
        return result;
    }

    private static boolean haveSourceOrReleaseArgument(List<String> args) {
        Iterator<String> allArgs = args.iterator();
        while (allArgs.hasNext()) {
            String option = allArgs.next();
            if (!"-source".equals(option) && !"--release".equals(option) || !allArgs.hasNext()) continue;
            return true;
        }
        return false;
    }

    private JavaCompiler getEcj() {
        ServiceLoader<JavaCompiler> javaCompilerLoader = ServiceLoader.load(JavaCompiler.class, BatchCompiler.class.getClassLoader());
        Class<?> c = null;
        try {
            c = Class.forName("org.eclipse.jdt.internal.compiler.tool.EclipseCompiler", false, BatchCompiler.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (c != null) {
            for (JavaCompiler javaCompiler : javaCompilerLoader) {
                if (!c.isInstance(javaCompiler)) continue;
                return javaCompiler;
            }
        }
        this.getLog().debug("Cannot find org.eclipse.jdt.internal.compiler.tool.EclipseCompiler");
        return null;
    }

    private CompilerMessage.Kind convert(Diagnostic.Kind kind) {
        if (kind == null) {
            return CompilerMessage.Kind.OTHER;
        }
        switch (kind) {
            case ERROR: {
                return this.errorsAsWarnings ? CompilerMessage.Kind.WARNING : CompilerMessage.Kind.ERROR;
            }
            case WARNING: {
                return CompilerMessage.Kind.WARNING;
            }
            case MANDATORY_WARNING: {
                return CompilerMessage.Kind.MANDATORY_WARNING;
            }
            case NOTE: {
                return CompilerMessage.Kind.NOTE;
            }
        }
        return CompilerMessage.Kind.OTHER;
    }

    private String getLastLines(String text, int lines) {
        ArrayList<String> lineList = new ArrayList<String>();
        text = text.replace("\r\n", "\n");
        text = text.replace("\r", "\n");
        int index = text.length();
        while (index > 0) {
            int before = text.lastIndexOf(10, index - 1);
            if (before + 1 < index) {
                lineList.add(text.substring(before + 1, index));
                if (--lines <= 0) break;
            }
            index = before;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = lineList.size() - 1; i >= 0; --i) {
            String s = (String)lineList.get(i);
            sb.append(s);
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    private static void append(StringBuilder warns, String s) {
        if (warns.length() > 0) {
            warns.append(',');
        }
        warns.append(s);
    }

    private boolean isPreJava1_6(CompilerConfiguration config) {
        String s = config.getSourceVersion();
        if (s == null) {
            return true;
        }
        return s.startsWith("1.5") || s.startsWith("1.4") || s.startsWith("1.3") || s.startsWith("1.2") || s.startsWith("1.1") || s.startsWith("1.0");
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return null;
    }

    public boolean supportsIncrementalCompilation() {
        return true;
    }

    private String decodeVersion(String versionSpec) {
        if (StringUtils.isEmpty((String)versionSpec)) {
            return null;
        }
        if (versionSpec.equals("1.9")) {
            this.getLog().warn("Version 9 should be specified as 9, not 1.9");
            return "9";
        }
        return versionSpec;
    }
}

