/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.csharp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.csharp.DefaultCSharpCompilerParser;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.WriterStreamConsumer;

public class CSharpCompiler
extends AbstractCompiler {
    private static final String ARGUMENTS_FILE_NAME = "csharp-arguments";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};

    public CSharpCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES, ".cs", null, null);
    }

    public boolean canUpdateTarget(CompilerConfiguration configuration) throws CompilerException {
        return false;
    }

    public String getOutputFile(CompilerConfiguration configuration) throws CompilerException {
        return configuration.getOutputFileName() + "." + this.getTypeExtension(configuration);
    }

    public List compile(CompilerConfiguration config) throws CompilerException {
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        config.setSourceFiles(null);
        String[] sourceFiles = CSharpCompiler.getSourceFiles(config);
        if (sourceFiles.length == 0) {
            return Collections.EMPTY_LIST;
        }
        System.out.println("Compiling " + sourceFiles.length + " " + "source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        String[] args = this.buildCompilerArguments(config, sourceFiles);
        if (!config.isFork()) {
            throw new CompilerException("This compiler doesn't support in-process compilation.");
        }
        List messages = this.compileOutOfProcess(config.getWorkingDirectory(), config.getBuildDirectory(), this.findExecutable(config), args);
        return messages;
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return this.buildCompilerArguments(config, CSharpCompiler.getSourceFiles(config));
    }

    private String findExecutable(CompilerConfiguration config) {
        String executable = config.getExecutable();
        if (!StringUtils.isEmpty((String)executable)) {
            return executable;
        }
        if (Os.isFamily((String)"windows")) {
            return "csc";
        }
        return "mcs";
    }

    private String[] buildCompilerArguments(CompilerConfiguration config, String[] sourceFiles) throws CompilerException {
        String target;
        String out;
        String nowarn;
        String doc;
        ArrayList<String> args = new ArrayList<String>();
        if (config.isDebug()) {
            args.add("/debug+");
        } else {
            args.add("/debug-");
        }
        Iterator it = config.getClasspathEntries().iterator();
        while (it.hasNext()) {
            String element = (String)it.next();
            File f = new File(element);
            if (!f.isFile()) continue;
            args.add("/reference:\"" + element + "\"");
        }
        LinkedHashMap compilerArguments = config.getCustomCompilerArguments();
        String mainClass = (String)compilerArguments.get("-main");
        if (!StringUtils.isEmpty((String)mainClass)) {
            args.add("/main:" + mainClass);
        }
        if (!StringUtils.isEmpty((String)(doc = (String)compilerArguments.get("-doc")))) {
            args.add("/doc:" + new File(config.getOutputLocation(), config.getOutputFileName() + ".xml").getAbsolutePath());
        }
        if (!StringUtils.isEmpty((String)(nowarn = (String)compilerArguments.get("-nowarn")))) {
            args.add("/nowarn:" + nowarn);
        }
        if (!StringUtils.isEmpty((String)(out = (String)compilerArguments.get("-out")))) {
            args.add("/out:" + new File(config.getOutputLocation(), out).getAbsolutePath());
        } else {
            args.add("/out:" + new File(config.getOutputLocation(), this.getOutputFile(config)).getAbsolutePath());
        }
        String resourcefile = (String)compilerArguments.get("-resourcefile");
        if (!StringUtils.isEmpty((String)resourcefile)) {
            String resourceTarget = (String)compilerArguments.get("-resourcetarget");
            args.add("/res:" + new File(resourcefile).getAbsolutePath() + "," + resourceTarget);
        }
        if (StringUtils.isEmpty((String)(target = (String)compilerArguments.get("-target")))) {
            args.add("/target:library");
        } else {
            args.add("/target:" + target);
        }
        String nologo = (String)compilerArguments.get("-nologo");
        if (!StringUtils.isEmpty((String)nologo)) {
            args.add("/nologo");
        }
        this.addResourceArgs(config, args);
        for (int i = 0; i < sourceFiles.length; ++i) {
            String sourceFile = sourceFiles[i];
            args.add(sourceFile);
        }
        return args.toArray(new String[args.size()]);
    }

    private void addResourceArgs(CompilerConfiguration config, List args) {
        File filteredResourceDir = this.findResourceDir(config);
        if (filteredResourceDir != null && filteredResourceDir.exists()) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(filteredResourceDir);
            scanner.setIncludes(DEFAULT_INCLUDES);
            scanner.addDefaultExcludes();
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            Iterator<String> iter = includedFiles.iterator();
            while (iter.hasNext()) {
                String name = iter.next();
                File filteredResource = new File(filteredResourceDir, name);
                String assemblyResourceName = this.convertNameToAssemblyResourceName(name);
                String argLine = "/resource:\"" + filteredResource + "\",\"" + assemblyResourceName + "\"";
                if (config.isDebug()) {
                    System.out.println("adding resource arg line:" + argLine);
                }
                args.add(argLine);
            }
        }
    }

    private File findResourceDir(CompilerConfiguration config) {
        if (config.isDebug()) {
            System.out.println("Looking for resourcesDir");
        }
        LinkedHashMap compilerArguments = config.getCustomCompilerArguments();
        String tempResourcesDirAsString = (String)compilerArguments.get("-resourceDir");
        File filteredResourceDir = null;
        if (tempResourcesDirAsString != null) {
            filteredResourceDir = new File(tempResourcesDirAsString);
            if (config.isDebug()) {
                System.out.println("Found resourceDir at: " + filteredResourceDir.toString());
            }
        } else if (config.isDebug()) {
            System.out.println("No resourceDir was available.");
        }
        return filteredResourceDir;
    }

    private String convertNameToAssemblyResourceName(String name) {
        return name.replace(File.separatorChar, '.');
    }

    private List compileOutOfProcess(File workingDirectory, File target, String executable, String[] args) throws CompilerException {
        List messages;
        int returnCode;
        File file;
        PrintWriter output = null;
        try {
            file = new File(target, ARGUMENTS_FILE_NAME);
            output = new PrintWriter(new FileWriter(file));
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                output.println(arg);
            }
        }
        catch (IOException e) {
            try {
                throw new CompilerException("Error writing arguments file.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(output);
                throw throwable;
            }
        }
        IOUtil.close((Writer)output);
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(workingDirectory.getAbsolutePath());
        cli.setExecutable(executable);
        cli.createArgument().setValue("@" + file.getAbsolutePath());
        StringWriter stringWriter = new StringWriter();
        WriterStreamConsumer out = new WriterStreamConsumer((Writer)stringWriter);
        WriterStreamConsumer err = new WriterStreamConsumer((Writer)stringWriter);
        try {
            returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
            messages = CSharpCompiler.parseCompilerOutput(new BufferedReader(new StringReader(((Object)stringWriter).toString())));
        }
        catch (CommandLineException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        catch (IOException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        if (returnCode != 0 && messages.isEmpty()) {
            messages.add(new CompilerError("Failure executing the compiler, but could not parse the error:" + AbstractCompiler.EOL + ((Object)stringWriter).toString(), true));
        }
        return messages;
    }

    public static List parseCompilerOutput(BufferedReader bufferedReader) throws IOException {
        ArrayList<CompilerError> messages = new ArrayList<CompilerError>();
        String line = bufferedReader.readLine();
        while (line != null) {
            CompilerError compilerError = DefaultCSharpCompilerParser.parseLine(line);
            if (compilerError != null) {
                messages.add(compilerError);
            }
            line = bufferedReader.readLine();
        }
        return messages;
    }

    private String getType(Map compilerArguments) {
        String type = (String)compilerArguments.get("-target");
        if (StringUtils.isEmpty((String)type)) {
            return "library";
        }
        return type;
    }

    private String getTypeExtension(CompilerConfiguration configuration) throws CompilerException {
        String type = this.getType(configuration.getCustomCompilerArguments());
        if (type.equals("exe") || type.equals("winexe")) {
            return "exe";
        }
        if (type.equals("library") || type.equals("module")) {
            return "dll";
        }
        throw new CompilerException("Unrecognized type '" + type + "'.");
    }

    protected static String[] getSourceFiles(CompilerConfiguration config) {
        Iterator it;
        HashSet<String> sources = new HashSet<String>();
        Set sourceFiles = config.getSourceFiles();
        if (sourceFiles != null && !sourceFiles.isEmpty()) {
            it = sourceFiles.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                File sourceFile = null;
                if (o instanceof String) {
                    sourceFile = new File((String)o);
                    System.out.println((String)o);
                } else {
                    if (!(o instanceof File)) break;
                    sourceFile = (File)o;
                }
                sources.add(sourceFile.getAbsolutePath());
            }
        } else {
            it = config.getSourceLocations().iterator();
            while (it.hasNext()) {
                String sourceLocation = (String)it.next();
                sources.addAll(CSharpCompiler.getSourceFilesForSourceRoot(config, sourceLocation));
            }
        }
        String[] result = sources.isEmpty() ? new String[]{} : sources.toArray(new String[sources.size()]);
        return result;
    }

    public static CompilerError parseLine(String line) {
        return DefaultCSharpCompilerParser.parseLine(line);
    }

    protected static Set getSourceFilesForSourceRoot(CompilerConfiguration config, String sourceLocation) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceLocation);
        Set includes = config.getIncludes();
        if (includes != null && !includes.isEmpty()) {
            String[] inclStrs = includes.toArray(new String[includes.size()]);
            scanner.setIncludes(inclStrs);
        } else {
            scanner.setIncludes(new String[]{"**/*.cs"});
        }
        Set excludes = config.getExcludes();
        if (excludes != null && !excludes.isEmpty()) {
            String[] exclStrs = excludes.toArray(new String[excludes.size()]);
            scanner.setIncludes(exclStrs);
        }
        scanner.scan();
        String[] sourceDirectorySources = scanner.getIncludedFiles();
        HashSet<String> sources = new HashSet<String>();
        for (int j = 0; j < sourceDirectorySources.length; ++j) {
            File f = new File(sourceLocation, sourceDirectorySources[j]);
            sources.add(f.getPath());
        }
        return sources;
    }
}

