/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ZipArchiveEntry;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ZipFile;
import org.codehaus.plexus.archiver.zip.ZipResource;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoArchiveResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlexusIoZipFileResourceCollection
extends AbstractPlexusIoArchiveResourceCollection {
    public static final String ROLE_HINT = "zip";

    protected Iterator<PlexusIoResource> getEntries() throws IOException {
        File f = this.getFile();
        if (f == null) {
            throw new IOException("The tar archive file has not been set.");
        }
        final ZipFile zipFile = new ZipFile(f);
        final Enumeration<ZipArchiveEntry> en = zipFile.getEntries();
        return new Iterator<PlexusIoResource>(){

            @Override
            public boolean hasNext() {
                return en.hasMoreElements();
            }

            @Override
            public PlexusIoResource next() {
                ZipArchiveEntry entry = (ZipArchiveEntry)en.nextElement();
                return new ZipResource(zipFile, entry, PlexusIoZipFileResourceCollection.this.getStreamTransformer());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing isn't implemented.");
            }
        };
    }
}

