/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.commonscompress.archivers.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.FileBasedScatterGatherBackingStore;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.InputStreamSupplier;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ScatterGatherBackingStore;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ScatterGatherBackingStoreSupplier;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ScatterZipOutputStream;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.StreamCompressor;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ZipArchiveEntry;
import org.codehaus.plexus.archiver.commonscompress.archivers.zip.ZipArchiveOutputStream;

public class ParallelScatterZipCreator {
    private List<ScatterZipOutputStream> streams = Collections.synchronizedList(new ArrayList());
    private final ExecutorService es;
    private final ScatterGatherBackingStoreSupplier supplier;
    private final long startedAt = System.currentTimeMillis();
    private long compressionDoneAt = 0L;
    private long scatterDoneAt;
    private ThreadLocal<ScatterZipOutputStream> tlScatterStreams = new ThreadLocal<ScatterZipOutputStream>(){

        @Override
        protected ScatterZipOutputStream initialValue() {
            try {
                ScatterZipOutputStream scatterStream = ParallelScatterZipCreator.this.createDeferred(ParallelScatterZipCreator.this.supplier);
                ParallelScatterZipCreator.this.streams.add(scatterStream);
                return scatterStream;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };

    private ScatterZipOutputStream createDeferred(ScatterGatherBackingStoreSupplier scatterGatherBackingStoreSupplier) throws IOException {
        ScatterGatherBackingStore bs = scatterGatherBackingStoreSupplier.get();
        StreamCompressor sc = StreamCompressor.create(-1, bs);
        return new ScatterZipOutputStream(bs, sc);
    }

    public ParallelScatterZipCreator() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public ParallelScatterZipCreator(int nThreads) {
        this(nThreads, new DefaultSupplier());
    }

    public ParallelScatterZipCreator(int nThreads, ScatterGatherBackingStoreSupplier backingStoreSupplier) {
        this.supplier = backingStoreSupplier;
        this.es = Executors.newFixedThreadPool(nThreads);
    }

    public void addArchiveEntry(final ZipArchiveEntry zipArchiveEntry, final InputStreamSupplier source) {
        final int method = zipArchiveEntry.getMethod();
        if (method == -1) {
            throw new IllegalArgumentException("Method must be set on the supplied zipArchiveEntry");
        }
        this.es.submit(new Callable<ScatterZipOutputStream>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ScatterZipOutputStream call() throws Exception {
                ScatterZipOutputStream streamToUse = (ScatterZipOutputStream)ParallelScatterZipCreator.this.tlScatterStreams.get();
                InputStream payload = source.get();
                try {
                    streamToUse.addArchiveEntry(zipArchiveEntry, payload, method);
                }
                finally {
                    payload.close();
                }
                return streamToUse;
            }
        });
    }

    public void writeTo(ZipArchiveOutputStream targetStream) throws IOException, InterruptedException {
        this.es.shutdown();
        this.es.awaitTermination(60000L, TimeUnit.SECONDS);
        this.compressionDoneAt = System.currentTimeMillis();
        for (ScatterZipOutputStream scatterStream : this.streams) {
            scatterStream.writeTo(targetStream);
            scatterStream.close();
        }
        this.scatterDoneAt = System.currentTimeMillis();
    }

    public String getStatisticsMessage() {
        return "Compression: " + (this.compressionDoneAt - this.startedAt) + "ms," + "Merging files: " + (this.scatterDoneAt - this.compressionDoneAt) + "ms";
    }

    private static class DefaultSupplier
    implements ScatterGatherBackingStoreSupplier {
        AtomicInteger storeNum = new AtomicInteger(0);

        private DefaultSupplier() {
        }

        public ScatterGatherBackingStore get() throws IOException {
            File tempFile = File.createTempFile("parallelscatter", "n" + this.storeNum.incrementAndGet());
            return new FileBasedScatterGatherBackingStore(tempFile);
        }
    }
}

